/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import org.apache.flink.kubernetes.shaded.io.fabric8.zjsonpatch.JsonDiff;

public class PatchUtils {
    private PatchUtils() {
    }

    public static String withoutRuntimeState(Object object, Format format, boolean omitStatus, KubernetesSerialization serialization) {
        Function<Object, String> mapper = format == Format.JSON ? serialization::asJson : serialization::asYaml;
        return mapper.apply(PatchUtils.withoutRuntimeState(object, omitStatus, serialization));
    }

    static JsonNode withoutRuntimeState(Object object, boolean omitStatus, KubernetesSerialization serialization) {
        ObjectNode raw = serialization.convertValue(object, ObjectNode.class);
        PatchUtils.removeEmptyArrays(raw);
        Optional.ofNullable(raw.get("metadata")).filter(ObjectNode.class::isInstance).map(ObjectNode.class::cast).ifPresent(m -> {
            m.remove("creationTimestamp");
            m.remove("deletionTimestamp");
            m.remove("generation");
            m.remove("selfLink");
            m.remove("uid");
        });
        if (omitStatus) {
            raw.remove("status");
        }
        return raw;
    }

    private static void removeEmptyArrays(ObjectNode raw) {
        ArrayList<String> toRemove = new ArrayList<String>();
        Iterator<String> names = raw.fieldNames();
        while (names.hasNext()) {
            String name = names.next();
            JsonNode node = raw.get(name);
            if (node.isArray() && node.size() == 0) {
                toRemove.add(name);
            }
            if (!node.isObject()) continue;
            PatchUtils.removeEmptyArrays((ObjectNode)node);
        }
        raw.remove(toRemove);
    }

    public static String jsonDiff(Object current, Object updated, boolean omitStatus, KubernetesSerialization serialization) {
        return serialization.asJson(JsonDiff.asJson(PatchUtils.withoutRuntimeState(current, omitStatus, serialization), PatchUtils.withoutRuntimeState(updated, omitStatus, serialization)));
    }

    public static enum Format {
        YAML,
        JSON;

    }
}

