/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent;

public class HTTPIngressPathFluent<A extends HTTPIngressPathFluent<A>>
extends BaseFluent<A> {
    private IngressBackendBuilder backend;
    private String path;
    private String pathType;
    private Map<String, Object> additionalProperties;

    public HTTPIngressPathFluent() {
    }

    public HTTPIngressPathFluent(HTTPIngressPath instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPIngressPath instance) {
        HTTPIngressPath hTTPIngressPath = instance = instance != null ? instance : new HTTPIngressPath();
        if (instance != null) {
            this.withBackend(instance.getBackend());
            this.withPath(instance.getPath());
            this.withPathType(instance.getPathType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public IngressBackend buildBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    public A withBackend(IngressBackend backend) {
        this._visitables.remove("backend");
        if (backend != null) {
            this.backend = new IngressBackendBuilder(backend);
            this._visitables.get("backend").add(this.backend);
        } else {
            this.backend = null;
            this._visitables.get("backend").remove(this.backend);
        }
        return (A)this;
    }

    public boolean hasBackend() {
        return this.backend != null;
    }

    public BackendNested<A> withNewBackend() {
        return new BackendNested(null);
    }

    public BackendNested<A> withNewBackendLike(IngressBackend item) {
        return new BackendNested(item);
    }

    public BackendNested<A> editBackend() {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(null));
    }

    public BackendNested<A> editOrNewBackend() {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(new IngressBackendBuilder().build()));
    }

    public BackendNested<A> editOrNewBackendLike(IngressBackend item) {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(item));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getPathType() {
        return this.pathType;
    }

    public A withPathType(String pathType) {
        this.pathType = pathType;
        return (A)this;
    }

    public boolean hasPathType() {
        return this.pathType != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPIngressPathFluent that = (HTTPIngressPathFluent)o;
        if (!Objects.equals(this.backend, that.backend)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.pathType, that.pathType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backend, this.path, this.pathType, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backend != null) {
            sb.append("backend:");
            sb.append(this.backend + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.pathType != null) {
            sb.append("pathType:");
            sb.append(this.pathType + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BackendNested<N>
    extends IngressBackendFluent<BackendNested<N>>
    implements Nested<N> {
        IngressBackendBuilder builder;

        BackendNested(IngressBackend item) {
            this.builder = new IngressBackendBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPIngressPathFluent.this.withBackend(this.builder.build());
        }

        public N endBackend() {
            return this.and();
        }
    }
}

