/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIServiceCondition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIServiceConditionBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIServiceConditionFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIServiceStatus;

public class APIServiceStatusFluent<A extends APIServiceStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<APIServiceConditionBuilder> conditions = new ArrayList();
    private Map<String, Object> additionalProperties;

    public APIServiceStatusFluent() {
    }

    public APIServiceStatusFluent(APIServiceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(APIServiceStatus instance) {
        APIServiceStatus aPIServiceStatus = instance = instance != null ? instance : new APIServiceStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, APIServiceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, APIServiceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(APIServiceCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (APIServiceCondition item : items) {
            APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<APIServiceCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (APIServiceCondition item : items) {
            APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(APIServiceCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (APIServiceCondition item : items) {
            APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<APIServiceCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (APIServiceCondition item : items) {
            APIServiceConditionBuilder builder = new APIServiceConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<APIServiceConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<APIServiceConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            APIServiceConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<APIServiceCondition> buildConditions() {
        return this.conditions != null ? APIServiceStatusFluent.build(this.conditions) : null;
    }

    public APIServiceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public APIServiceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public APIServiceCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public APIServiceCondition buildMatchingCondition(Predicate<APIServiceConditionBuilder> predicate) {
        for (APIServiceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<APIServiceConditionBuilder> predicate) {
        for (APIServiceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<APIServiceCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (APIServiceCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(APIServiceCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (APIServiceCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new APIServiceCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(APIServiceCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, APIServiceCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<APIServiceConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServiceStatusFluent that = (APIServiceStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends APIServiceConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        APIServiceConditionBuilder builder;
        int index;

        ConditionsNested(int index, APIServiceCondition item) {
            this.index = index;
            this.builder = new APIServiceConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIServiceStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

