/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Config;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.ConfigBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.HttpClientUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;

public class KubernetesClientBuilder {
    private Config config;
    private HttpClient.Factory factory;
    private Class<KubernetesClient> clazz;
    private ExecutorSupplier executorSupplier;
    private Consumer<HttpClient.Builder> builderConsumer;
    private KubernetesSerialization kubernetesSerialization = new KubernetesSerialization();

    public KubernetesClientBuilder() {
        String className = "org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.impl.KubernetesClientImpl";
        try {
            this.clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassCastException | ClassNotFoundException | NullPointerException e) {
            try {
                this.clazz = KubernetesClient.class.getClassLoader().loadClass(className);
            }
            catch (Exception ex) {
                throw KubernetesClientException.launderThrowable(ex);
            }
        }
    }

    KubernetesClientBuilder(Class<KubernetesClient> clazz) {
        this.clazz = clazz;
    }

    public KubernetesClient build() {
        if (this.config == null) {
            this.config = new ConfigBuilder().build();
        }
        try {
            if (this.factory == null) {
                this.factory = HttpClientUtils.getHttpClientFactory();
            }
            HttpClient client = this.getHttpClient();
            return this.clazz.getConstructor(HttpClient.class, Config.class, ExecutorSupplier.class, KubernetesSerialization.class).newInstance(client, this.config, this.executorSupplier, this.kubernetesSerialization);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    HttpClient getHttpClient() {
        HttpClient.Builder builder = this.factory.newBuilder(this.config);
        if (this.builderConsumer != null) {
            this.builderConsumer.accept(builder);
        }
        return builder.build();
    }

    public KubernetesClientBuilder withConfig(Config config) {
        this.config = config;
        return this;
    }

    public KubernetesClientBuilder withKubernetesSerialization(KubernetesSerialization kubernetesSerialization) {
        this.kubernetesSerialization = Utils.checkNotNull(kubernetesSerialization, "kubernetesSerialization must not be null");
        return this;
    }

    public KubernetesClientBuilder withConfig(String config) {
        this.config = this.kubernetesSerialization.unmarshal(config, Config.class);
        return this;
    }

    public KubernetesClientBuilder withConfig(InputStream config) {
        this.config = this.kubernetesSerialization.unmarshal(config, Config.class);
        return this;
    }

    public KubernetesClientBuilder withHttpClientFactory(HttpClient.Factory factory) {
        this.factory = factory;
        return this;
    }

    public KubernetesClientBuilder withTaskExecutor(Executor executor) {
        this.executorSupplier = () -> executor;
        return this;
    }

    public KubernetesClientBuilder withTaskExecutorSupplier(ExecutorSupplier executorSupplier) {
        this.executorSupplier = executorSupplier;
        return this;
    }

    public KubernetesClientBuilder withHttpClientBuilderConsumer(Consumer<HttpClient.Builder> consumer) {
        this.builderConsumer = consumer;
        return this;
    }

    @FunctionalInterface
    public static interface ExecutorSupplier
    extends Supplier<Executor> {
        default public void onClose(Executor executor) {
        }
    }
}

