/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.AsyncBody;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpResponse;

public class HttpClientReadableByteChannel
implements ReadableByteChannel,
AsyncBody.Consumer<List<ByteBuffer>> {
    private final LinkedList<ByteBuffer> buffers = new LinkedList();
    private Throwable failed;
    private boolean closed;
    private boolean done;
    private CompletableFuture<AsyncBody> asyncBodyFuture = new CompletableFuture();
    private ByteBuffer currentBuffer;
    private ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();

    @Override
    public void consume(List<ByteBuffer> value, AsyncBody asyncBody) throws Exception {
        this.doLockedAndSignal(() -> this.buffers.addAll(value));
    }

    protected void onResponse(HttpResponse<AsyncBody> response) {
        AsyncBody asyncBody = response.body();
        this.asyncBodyFuture.complete(asyncBody);
        asyncBody.done().whenComplete(this::onBodyDone);
        asyncBody.consume();
        this.doLockedAndSignal(() -> null);
    }

    private void onBodyDone(Void v, Throwable t) {
        this.doLockedAndSignal(() -> {
            if (t != null) {
                this.failed = t;
            }
            this.done = true;
            return null;
        });
    }

    <T> T doLockedAndSignal(Supplier<T> run) {
        this.lock.lock();
        try {
            this.condition.signalAll();
            T t = run.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        if (this.doLockedAndSignal(() -> {
            if (this.closed) {
                return false;
            }
            this.closed = true;
            return true;
        }).booleanValue()) {
            this.asyncBodyFuture.thenAccept(AsyncBody::cancel);
        }
    }

    @Override
    public synchronized boolean isOpen() {
        return !this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer arg0) throws IOException {
        this.lock.lock();
        try {
            int n;
            if (this.closed) {
                throw new ClosedChannelException();
            }
            int read = 0;
            while (arg0.hasRemaining()) {
                while (this.currentBuffer == null || !this.currentBuffer.hasRemaining()) {
                    if (this.buffers.isEmpty()) {
                        if (this.failed != null) {
                            throw new IOException("channel already closed with exception", this.failed);
                        }
                        if (read > 0) {
                            n = read;
                            return n;
                        }
                        if (this.done) {
                            n = -1;
                            return n;
                        }
                        this.lock.unlock();
                        try {
                            this.asyncBodyFuture.thenAccept(AsyncBody::consume);
                        }
                        finally {
                            this.lock.lock();
                        }
                        try {
                            while (!this.done && this.buffers.isEmpty()) {
                                this.condition.await();
                            }
                        }
                        catch (InterruptedException e) {
                            this.close();
                            Thread.currentThread().interrupt();
                            throw new ClosedByInterruptException();
                        }
                    }
                    this.currentBuffer = this.buffers.poll();
                }
                int remaining = Math.min(arg0.remaining(), this.currentBuffer.remaining());
                for (int i = 0; i < remaining; ++i) {
                    arg0.put(this.currentBuffer.get());
                }
                read += remaining;
            }
            n = read;
            return n;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }
}

