/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LocalObjectReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

public class ISCSIVolumeSourceFluent<A extends ISCSIVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private Boolean chapAuthDiscovery;
    private Boolean chapAuthSession;
    private String fsType;
    private String initiatorName;
    private String iqn;
    private String iscsiInterface;
    private Integer lun;
    private List<String> portals = new ArrayList<String>();
    private Boolean readOnly;
    private LocalObjectReferenceBuilder secretRef;
    private String targetPortal;
    private Map<String, Object> additionalProperties;

    public ISCSIVolumeSourceFluent() {
    }

    public ISCSIVolumeSourceFluent(ISCSIVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ISCSIVolumeSource instance) {
        ISCSIVolumeSource iSCSIVolumeSource = instance = instance != null ? instance : new ISCSIVolumeSource();
        if (instance != null) {
            this.withChapAuthDiscovery(instance.getChapAuthDiscovery());
            this.withChapAuthSession(instance.getChapAuthSession());
            this.withFsType(instance.getFsType());
            this.withInitiatorName(instance.getInitiatorName());
            this.withIqn(instance.getIqn());
            this.withIscsiInterface(instance.getIscsiInterface());
            this.withLun(instance.getLun());
            this.withPortals(instance.getPortals());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withTargetPortal(instance.getTargetPortal());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getChapAuthDiscovery() {
        return this.chapAuthDiscovery;
    }

    public A withChapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
        return (A)this;
    }

    public boolean hasChapAuthDiscovery() {
        return this.chapAuthDiscovery != null;
    }

    public Boolean getChapAuthSession() {
        return this.chapAuthSession;
    }

    public A withChapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
        return (A)this;
    }

    public boolean hasChapAuthSession() {
        return this.chapAuthSession != null;
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public A withInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
        return (A)this;
    }

    public boolean hasInitiatorName() {
        return this.initiatorName != null;
    }

    public String getIqn() {
        return this.iqn;
    }

    public A withIqn(String iqn) {
        this.iqn = iqn;
        return (A)this;
    }

    public boolean hasIqn() {
        return this.iqn != null;
    }

    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    public A withIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
        return (A)this;
    }

    public boolean hasIscsiInterface() {
        return this.iscsiInterface != null;
    }

    public Integer getLun() {
        return this.lun;
    }

    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)this;
    }

    public boolean hasLun() {
        return this.lun != null;
    }

    public A addToPortals(int index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.add(index, item);
        return (A)this;
    }

    public A setToPortals(int index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.set(index, item);
        return (A)this;
    }

    public A addToPortals(String ... items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    public A addAllToPortals(Collection<String> items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    public A removeFromPortals(String ... items) {
        if (this.portals == null) {
            return (A)this;
        }
        for (String item : items) {
            this.portals.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromPortals(Collection<String> items) {
        if (this.portals == null) {
            return (A)this;
        }
        for (String item : items) {
            this.portals.remove(item);
        }
        return (A)this;
    }

    public List<String> getPortals() {
        return this.portals;
    }

    public String getPortal(int index) {
        return this.portals.get(index);
    }

    public String getFirstPortal() {
        return this.portals.get(0);
    }

    public String getLastPortal() {
        return this.portals.get(this.portals.size() - 1);
    }

    public String getMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPortals(List<String> portals) {
        if (portals != null) {
            this.portals = new ArrayList<String>();
            for (String item : portals) {
                this.addToPortals(item);
            }
        } else {
            this.portals = null;
        }
        return (A)this;
    }

    public A withPortals(String ... portals) {
        if (this.portals != null) {
            this.portals.clear();
            this._visitables.remove("portals");
        }
        if (portals != null) {
            for (String item : portals) {
                this.addToPortals(item);
            }
        }
        return (A)this;
    }

    public boolean hasPortals() {
        return this.portals != null && !this.portals.isEmpty();
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.remove("secretRef");
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public String getTargetPortal() {
        return this.targetPortal;
    }

    public A withTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
        return (A)this;
    }

    public boolean hasTargetPortal() {
        return this.targetPortal != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ISCSIVolumeSourceFluent that = (ISCSIVolumeSourceFluent)o;
        if (!Objects.equals(this.chapAuthDiscovery, that.chapAuthDiscovery)) {
            return false;
        }
        if (!Objects.equals(this.chapAuthSession, that.chapAuthSession)) {
            return false;
        }
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.initiatorName, that.initiatorName)) {
            return false;
        }
        if (!Objects.equals(this.iqn, that.iqn)) {
            return false;
        }
        if (!Objects.equals(this.iscsiInterface, that.iscsiInterface)) {
            return false;
        }
        if (!Objects.equals(this.lun, that.lun)) {
            return false;
        }
        if (!Objects.equals(this.portals, that.portals)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.targetPortal, that.targetPortal)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.chapAuthDiscovery, this.chapAuthSession, this.fsType, this.initiatorName, this.iqn, this.iscsiInterface, this.lun, this.portals, this.readOnly, this.secretRef, this.targetPortal, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.chapAuthDiscovery != null) {
            sb.append("chapAuthDiscovery:");
            sb.append(this.chapAuthDiscovery + ",");
        }
        if (this.chapAuthSession != null) {
            sb.append("chapAuthSession:");
            sb.append(this.chapAuthSession + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.initiatorName != null) {
            sb.append("initiatorName:");
            sb.append(this.initiatorName + ",");
        }
        if (this.iqn != null) {
            sb.append("iqn:");
            sb.append(this.iqn + ",");
        }
        if (this.iscsiInterface != null) {
            sb.append("iscsiInterface:");
            sb.append(this.iscsiInterface + ",");
        }
        if (this.lun != null) {
            sb.append("lun:");
            sb.append(this.lun + ",");
        }
        if (this.portals != null && !this.portals.isEmpty()) {
            sb.append("portals:");
            sb.append(this.portals + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.targetPortal != null) {
            sb.append("targetPortal:");
            sb.append(this.targetPortal + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withChapAuthDiscovery() {
        return this.withChapAuthDiscovery(true);
    }

    public A withChapAuthSession() {
        return this.withChapAuthSession(true);
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class SecretRefNested<N>
    extends LocalObjectReferenceFluent<SecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ISCSIVolumeSourceFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }
}

