/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.kubeclient.services.HeadlessClusterIPService;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Service;
import org.apache.flink.util.Preconditions;

public class InternalServiceDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesJobManagerParameters kubernetesJobManagerParameters;

    public InternalServiceDecorator(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        this.kubernetesJobManagerParameters = (KubernetesJobManagerParameters)Preconditions.checkNotNull((Object)kubernetesJobManagerParameters);
    }

    @Override
    public List<HasMetadata> buildAccompanyingKubernetesResources() throws IOException {
        if (!this.kubernetesJobManagerParameters.isInternalServiceEnabled()) {
            return Collections.emptyList();
        }
        String serviceName = InternalServiceDecorator.getInternalServiceName(this.kubernetesJobManagerParameters.getClusterId());
        Service headlessService = HeadlessClusterIPService.INSTANCE.buildUpInternalService(this.kubernetesJobManagerParameters);
        String namespace = this.kubernetesJobManagerParameters.getNamespace();
        this.kubernetesJobManagerParameters.getFlinkConfiguration().set(JobManagerOptions.ADDRESS, (Object)InternalServiceDecorator.getNamespacedInternalServiceName(serviceName, namespace));
        return Collections.singletonList(headlessService);
    }

    public static String getInternalServiceName(String clusterId) {
        return clusterId;
    }

    public static String getNamespacedInternalServiceName(String clusterId, String namespace) {
        return InternalServiceDecorator.getInternalServiceName(clusterId) + "." + namespace;
    }
}

