/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Nullable;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.reconciler.ReconciliationMetadata;
import org.apache.flink.kubernetes.operator.api.spec.AbstractFlinkSpec;
import org.apache.flink.kubernetes.operator.api.utils.SpecWithMeta;

public class SpecUtils {
    public static final String INTERNAL_METADATA_JSON_KEY = "resource_metadata";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T extends AbstractFlinkSpec> SpecWithMeta<T> deserializeSpecWithMeta(@Nullable String specWithMetaString, Class<T> specClass) {
        if (specWithMetaString == null) {
            return null;
        }
        try {
            ObjectNode wrapper = (ObjectNode)objectMapper.readTree(specWithMetaString);
            ObjectNode internalMeta = (ObjectNode)wrapper.remove(INTERNAL_METADATA_JSON_KEY);
            if (internalMeta == null) {
                wrapper.remove("apiVersion");
                return new SpecWithMeta<AbstractFlinkSpec>((AbstractFlinkSpec)objectMapper.treeToValue((TreeNode)wrapper, specClass), null);
            }
            internalMeta.remove("metadata");
            return new SpecWithMeta<AbstractFlinkSpec>((AbstractFlinkSpec)objectMapper.treeToValue((TreeNode)wrapper.get("spec"), specClass), (ReconciliationMetadata)objectMapper.convertValue((Object)internalMeta, ReconciliationMetadata.class));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not deserialize spec, this indicates a bug...", e);
        }
    }

    public static String writeSpecWithMeta(AbstractFlinkSpec spec, AbstractFlinkResource<?, ?> relatedResource) {
        return SpecUtils.writeSpecWithMeta(spec, ReconciliationMetadata.from(relatedResource));
    }

    public static String writeSpecWithMeta(AbstractFlinkSpec spec, ReconciliationMetadata metadata) {
        ObjectNode wrapper = objectMapper.createObjectNode();
        wrapper.set("spec", objectMapper.valueToTree((Object)SpecUtils.checkNotNull(spec)));
        wrapper.set(INTERNAL_METADATA_JSON_KEY, objectMapper.valueToTree((Object)SpecUtils.checkNotNull(metadata)));
        try {
            return objectMapper.writeValueAsString((Object)wrapper);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not serialize spec, this indicates a bug...", e);
        }
    }

    private static <T> T checkNotNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static <T> T clone(T object) {
        if (object == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(objectMapper.writeValueAsString(object), object.getClass());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

