/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.status;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.status.Savepoint;
import org.apache.flink.kubernetes.operator.api.status.SavepointFormatType;
import org.apache.flink.kubernetes.operator.api.status.Snapshot;
import org.apache.flink.kubernetes.operator.api.status.SnapshotInfo;
import org.apache.flink.kubernetes.operator.api.status.SnapshotTriggerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Experimental
public class SavepointInfo
implements SnapshotInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SavepointInfo.class);
    private Savepoint lastSavepoint;
    private String triggerId;
    private Long triggerTimestamp;
    private SnapshotTriggerType triggerType;
    private SavepointFormatType formatType;
    private List<Savepoint> savepointHistory = new ArrayList<Savepoint>();
    private long lastPeriodicSavepointTimestamp = 0L;

    public void setTrigger(String triggerId, SnapshotTriggerType triggerType, SavepointFormatType formatType) {
        this.triggerId = triggerId;
        this.triggerTimestamp = System.currentTimeMillis();
        this.triggerType = triggerType;
        this.formatType = formatType;
    }

    @Override
    public void resetTrigger() {
        this.triggerId = null;
        this.triggerTimestamp = null;
        this.triggerType = null;
        this.formatType = null;
    }

    public void updateLastSavepoint(Savepoint savepoint) {
        if (savepoint == null) {
            this.lastSavepoint = null;
        } else if (this.lastSavepoint == null || !this.lastSavepoint.getLocation().equals(savepoint.getLocation())) {
            LOG.debug("Updating last savepoint to {}", (Object)savepoint);
            this.lastSavepoint = savepoint;
            this.savepointHistory.add(savepoint);
            if (savepoint.getTriggerType() == SnapshotTriggerType.PERIODIC) {
                this.lastPeriodicSavepointTimestamp = savepoint.getTimeStamp();
            }
        }
        this.resetTrigger();
    }

    @Override
    @JsonIgnore
    public Long getLastTriggerNonce() {
        return this.lastSavepoint == null ? null : this.lastSavepoint.getTriggerNonce();
    }

    @Override
    @JsonIgnore
    public long getLastPeriodicTriggerTimestamp() {
        return this.lastPeriodicSavepointTimestamp;
    }

    @Override
    @JsonIgnore
    public SnapshotTriggerType getLastTriggerType() {
        return this.lastSavepoint == null ? null : this.lastSavepoint.getTriggerType();
    }

    @Override
    @JsonIgnore
    public String formatErrorMessage(Long triggerNonce) {
        return SnapshotTriggerType.PERIODIC == this.triggerType ? "Periodic savepoint failed" : "Savepoint failed for savepointTriggerNonce: " + triggerNonce;
    }

    @Override
    @JsonIgnore
    public Snapshot getLastSnapshot() {
        return this.lastSavepoint;
    }

    public static SavepointInfoBuilder builder() {
        return new SavepointInfoBuilder();
    }

    public Savepoint getLastSavepoint() {
        return this.lastSavepoint;
    }

    @Override
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    public Long getTriggerTimestamp() {
        return this.triggerTimestamp;
    }

    @Override
    public SnapshotTriggerType getTriggerType() {
        return this.triggerType;
    }

    public SavepointFormatType getFormatType() {
        return this.formatType;
    }

    public List<Savepoint> getSavepointHistory() {
        return this.savepointHistory;
    }

    public long getLastPeriodicSavepointTimestamp() {
        return this.lastPeriodicSavepointTimestamp;
    }

    public void setLastSavepoint(Savepoint lastSavepoint) {
        this.lastSavepoint = lastSavepoint;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public void setTriggerTimestamp(Long triggerTimestamp) {
        this.triggerTimestamp = triggerTimestamp;
    }

    public void setTriggerType(SnapshotTriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setFormatType(SavepointFormatType formatType) {
        this.formatType = formatType;
    }

    public void setSavepointHistory(List<Savepoint> savepointHistory) {
        this.savepointHistory = savepointHistory;
    }

    public void setLastPeriodicSavepointTimestamp(long lastPeriodicSavepointTimestamp) {
        this.lastPeriodicSavepointTimestamp = lastPeriodicSavepointTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SavepointInfo)) {
            return false;
        }
        SavepointInfo other = (SavepointInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastPeriodicSavepointTimestamp() != other.getLastPeriodicSavepointTimestamp()) {
            return false;
        }
        Long this$triggerTimestamp = this.getTriggerTimestamp();
        Long other$triggerTimestamp = other.getTriggerTimestamp();
        if (this$triggerTimestamp == null ? other$triggerTimestamp != null : !((Object)this$triggerTimestamp).equals(other$triggerTimestamp)) {
            return false;
        }
        Savepoint this$lastSavepoint = this.getLastSavepoint();
        Savepoint other$lastSavepoint = other.getLastSavepoint();
        if (this$lastSavepoint == null ? other$lastSavepoint != null : !((Object)this$lastSavepoint).equals(other$lastSavepoint)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        SnapshotTriggerType this$triggerType = this.getTriggerType();
        SnapshotTriggerType other$triggerType = other.getTriggerType();
        if (this$triggerType == null ? other$triggerType != null : !((Object)((Object)this$triggerType)).equals((Object)other$triggerType)) {
            return false;
        }
        SavepointFormatType this$formatType = this.getFormatType();
        SavepointFormatType other$formatType = other.getFormatType();
        if (this$formatType == null ? other$formatType != null : !((Object)((Object)this$formatType)).equals((Object)other$formatType)) {
            return false;
        }
        List<Savepoint> this$savepointHistory = this.getSavepointHistory();
        List<Savepoint> other$savepointHistory = other.getSavepointHistory();
        return !(this$savepointHistory == null ? other$savepointHistory != null : !((Object)this$savepointHistory).equals(other$savepointHistory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SavepointInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastPeriodicSavepointTimestamp = this.getLastPeriodicSavepointTimestamp();
        result = result * 59 + (int)($lastPeriodicSavepointTimestamp >>> 32 ^ $lastPeriodicSavepointTimestamp);
        Long $triggerTimestamp = this.getTriggerTimestamp();
        result = result * 59 + ($triggerTimestamp == null ? 43 : ((Object)$triggerTimestamp).hashCode());
        Savepoint $lastSavepoint = this.getLastSavepoint();
        result = result * 59 + ($lastSavepoint == null ? 43 : ((Object)$lastSavepoint).hashCode());
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        SnapshotTriggerType $triggerType = this.getTriggerType();
        result = result * 59 + ($triggerType == null ? 43 : ((Object)((Object)$triggerType)).hashCode());
        SavepointFormatType $formatType = this.getFormatType();
        result = result * 59 + ($formatType == null ? 43 : ((Object)((Object)$formatType)).hashCode());
        List<Savepoint> $savepointHistory = this.getSavepointHistory();
        result = result * 59 + ($savepointHistory == null ? 43 : ((Object)$savepointHistory).hashCode());
        return result;
    }

    public String toString() {
        return "SavepointInfo(lastSavepoint=" + this.getLastSavepoint() + ", triggerId=" + this.getTriggerId() + ", triggerTimestamp=" + this.getTriggerTimestamp() + ", triggerType=" + this.getTriggerType() + ", formatType=" + this.getFormatType() + ", savepointHistory=" + this.getSavepointHistory() + ", lastPeriodicSavepointTimestamp=" + this.getLastPeriodicSavepointTimestamp() + ")";
    }

    public SavepointInfo() {
    }

    public SavepointInfo(Savepoint lastSavepoint, String triggerId, Long triggerTimestamp, SnapshotTriggerType triggerType, SavepointFormatType formatType, List<Savepoint> savepointHistory, long lastPeriodicSavepointTimestamp) {
        this.lastSavepoint = lastSavepoint;
        this.triggerId = triggerId;
        this.triggerTimestamp = triggerTimestamp;
        this.triggerType = triggerType;
        this.formatType = formatType;
        this.savepointHistory = savepointHistory;
        this.lastPeriodicSavepointTimestamp = lastPeriodicSavepointTimestamp;
    }

    public static class SavepointInfoBuilder {
        private Savepoint lastSavepoint;
        private String triggerId;
        private Long triggerTimestamp;
        private SnapshotTriggerType triggerType;
        private SavepointFormatType formatType;
        private List<Savepoint> savepointHistory;
        private long lastPeriodicSavepointTimestamp;

        SavepointInfoBuilder() {
        }

        public SavepointInfoBuilder lastSavepoint(Savepoint lastSavepoint) {
            this.lastSavepoint = lastSavepoint;
            return this;
        }

        public SavepointInfoBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        public SavepointInfoBuilder triggerTimestamp(Long triggerTimestamp) {
            this.triggerTimestamp = triggerTimestamp;
            return this;
        }

        public SavepointInfoBuilder triggerType(SnapshotTriggerType triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        public SavepointInfoBuilder formatType(SavepointFormatType formatType) {
            this.formatType = formatType;
            return this;
        }

        public SavepointInfoBuilder savepointHistory(List<Savepoint> savepointHistory) {
            this.savepointHistory = savepointHistory;
            return this;
        }

        public SavepointInfoBuilder lastPeriodicSavepointTimestamp(long lastPeriodicSavepointTimestamp) {
            this.lastPeriodicSavepointTimestamp = lastPeriodicSavepointTimestamp;
            return this;
        }

        public SavepointInfo build() {
            return new SavepointInfo(this.lastSavepoint, this.triggerId, this.triggerTimestamp, this.triggerType, this.formatType, this.savepointHistory, this.lastPeriodicSavepointTimestamp);
        }

        public String toString() {
            return "SavepointInfo.SavepointInfoBuilder(lastSavepoint=" + this.lastSavepoint + ", triggerId=" + this.triggerId + ", triggerTimestamp=" + this.triggerTimestamp + ", triggerType=" + this.triggerType + ", formatType=" + this.formatType + ", savepointHistory=" + this.savepointHistory + ", lastPeriodicSavepointTimestamp=" + this.lastPeriodicSavepointTimestamp + ")";
        }
    }
}

