/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.status;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.spec.AbstractFlinkSpec;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationState;
import org.apache.flink.kubernetes.operator.api.utils.SpecUtils;
import org.apache.flink.kubernetes.operator.api.utils.SpecWithMeta;

@Experimental
public abstract class ReconciliationStatus<SPEC extends AbstractFlinkSpec> {
    private long reconciliationTimestamp;
    private String lastReconciledSpec;
    private String lastStableSpec;
    private ReconciliationState state = ReconciliationState.UPGRADING;

    @JsonIgnore
    public abstract Class<SPEC> getSpecClass();

    @JsonIgnore
    public SPEC deserializeLastReconciledSpec() {
        SpecWithMeta<SPEC> specWithMeta = this.deserializeLastReconciledSpecWithMeta();
        return specWithMeta != null ? (SPEC)specWithMeta.getSpec() : null;
    }

    @JsonIgnore
    public SPEC deserializeLastStableSpec() {
        SpecWithMeta<SPEC> specWithMeta = this.deserializeLastStableSpecWithMeta();
        return specWithMeta != null ? (SPEC)specWithMeta.getSpec() : null;
    }

    @JsonIgnore
    public SpecWithMeta<SPEC> deserializeLastReconciledSpecWithMeta() {
        return SpecUtils.deserializeSpecWithMeta(this.lastReconciledSpec, this.getSpecClass());
    }

    @JsonIgnore
    public SpecWithMeta<SPEC> deserializeLastStableSpecWithMeta() {
        return SpecUtils.deserializeSpecWithMeta(this.lastStableSpec, this.getSpecClass());
    }

    @JsonIgnore
    public void serializeAndSetLastReconciledSpec(SPEC spec, AbstractFlinkResource<SPEC, ?> resource) {
        this.setLastReconciledSpec(SpecUtils.writeSpecWithMeta(spec, resource));
        ((CommonStatus)resource.getStatus()).setObservedGeneration(resource.getMetadata().getGeneration());
    }

    public void markReconciledSpecAsStable() {
        this.lastStableSpec = this.lastReconciledSpec;
    }

    @JsonIgnore
    public boolean isLastReconciledSpecStable() {
        if (this.lastReconciledSpec == null || this.lastStableSpec == null) {
            return false;
        }
        return this.lastReconciledSpec.equals(this.lastStableSpec);
    }

    @JsonIgnore
    public boolean isBeforeFirstDeployment() {
        return this.lastReconciledSpec == null;
    }

    public long getReconciliationTimestamp() {
        return this.reconciliationTimestamp;
    }

    public String getLastReconciledSpec() {
        return this.lastReconciledSpec;
    }

    public String getLastStableSpec() {
        return this.lastStableSpec;
    }

    public ReconciliationState getState() {
        return this.state;
    }

    public void setReconciliationTimestamp(long reconciliationTimestamp) {
        this.reconciliationTimestamp = reconciliationTimestamp;
    }

    public void setLastReconciledSpec(String lastReconciledSpec) {
        this.lastReconciledSpec = lastReconciledSpec;
    }

    public void setLastStableSpec(String lastStableSpec) {
        this.lastStableSpec = lastStableSpec;
    }

    public void setState(ReconciliationState state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReconciliationStatus)) {
            return false;
        }
        ReconciliationStatus other = (ReconciliationStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReconciliationTimestamp() != other.getReconciliationTimestamp()) {
            return false;
        }
        String this$lastReconciledSpec = this.getLastReconciledSpec();
        String other$lastReconciledSpec = other.getLastReconciledSpec();
        if (this$lastReconciledSpec == null ? other$lastReconciledSpec != null : !this$lastReconciledSpec.equals(other$lastReconciledSpec)) {
            return false;
        }
        String this$lastStableSpec = this.getLastStableSpec();
        String other$lastStableSpec = other.getLastStableSpec();
        if (this$lastStableSpec == null ? other$lastStableSpec != null : !this$lastStableSpec.equals(other$lastStableSpec)) {
            return false;
        }
        ReconciliationState this$state = this.getState();
        ReconciliationState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReconciliationStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $reconciliationTimestamp = this.getReconciliationTimestamp();
        result = result * 59 + (int)($reconciliationTimestamp >>> 32 ^ $reconciliationTimestamp);
        String $lastReconciledSpec = this.getLastReconciledSpec();
        result = result * 59 + ($lastReconciledSpec == null ? 43 : $lastReconciledSpec.hashCode());
        String $lastStableSpec = this.getLastStableSpec();
        result = result * 59 + ($lastStableSpec == null ? 43 : $lastStableSpec.hashCode());
        ReconciliationState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public String toString() {
        return "ReconciliationStatus(reconciliationTimestamp=" + this.getReconciliationTimestamp() + ", lastReconciledSpec=" + this.getLastReconciledSpec() + ", lastStableSpec=" + this.getLastStableSpec() + ", state=" + this.getState() + ")";
    }
}

