/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;

@Public
public class ParameterTool
extends ExecutionConfig.GlobalJobParameters
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected static final String NO_VALUE_KEY = "__NO_VALUE_KEY";
    protected static final String DEFAULT_UNDEFINED = "<undefined>";
    protected final Map<String, String> data;
    protected transient Map<String, String> defaultData;
    protected transient Set<String> unrequestedParameters;

    public static ParameterTool fromArgs(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>(args.length / 2);
        int i = 0;
        while (i < args.length) {
            String key;
            if (args[i].startsWith("--")) {
                key = args[i].substring(2);
            } else if (args[i].startsWith("-")) {
                key = args[i].substring(1);
            } else {
                throw new IllegalArgumentException(String.format("Error parsing arguments '%s' on '%s'. Please prefix keys with -- or -.", Arrays.toString(args), args[i]));
            }
            if (key.isEmpty()) {
                throw new IllegalArgumentException("The input " + Arrays.toString(args) + " contains an empty argument");
            }
            if (++i >= args.length) {
                map.put(key, NO_VALUE_KEY);
                continue;
            }
            if (NumberUtils.isNumber((String)args[i])) {
                map.put(key, args[i]);
                ++i;
                continue;
            }
            if (args[i].startsWith("--") || args[i].startsWith("-")) {
                map.put(key, NO_VALUE_KEY);
                continue;
            }
            map.put(key, args[i]);
            ++i;
        }
        return ParameterTool.fromMap(map);
    }

    public static ParameterTool fromPropertiesFile(String path) throws IOException {
        File propertiesFile = new File(path);
        return ParameterTool.fromPropertiesFile(propertiesFile);
    }

    public static ParameterTool fromPropertiesFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Properties file " + file.getAbsolutePath() + " does not exist");
        }
        try (FileInputStream fis = new FileInputStream(file);){
            ParameterTool parameterTool = ParameterTool.fromPropertiesFile(fis);
            return parameterTool;
        }
    }

    public static ParameterTool fromPropertiesFile(InputStream inputStream) throws IOException {
        Properties props = new Properties();
        props.load(inputStream);
        return ParameterTool.fromMap(props);
    }

    public static ParameterTool fromMap(Map<String, String> map) {
        Preconditions.checkNotNull(map, (String)"Unable to initialize from empty map");
        return new ParameterTool(map);
    }

    public static ParameterTool fromSystemProperties() {
        return ParameterTool.fromMap(System.getProperties());
    }

    private ParameterTool(Map<String, String> data) {
        this.data = Collections.unmodifiableMap(new HashMap<String, String>(data));
        this.defaultData = new ConcurrentHashMap<String, String>(data.size());
        this.unrequestedParameters = Collections.newSetFromMap(new ConcurrentHashMap(data.size()));
        this.unrequestedParameters.addAll(data.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterTool that = (ParameterTool)o;
        return Objects.equals(this.data, that.data) && Objects.equals(this.defaultData, that.defaultData) && Objects.equals(this.unrequestedParameters, that.unrequestedParameters);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.defaultData, this.unrequestedParameters);
    }

    @PublicEvolving
    public Set<String> getUnrequestedParameters() {
        return Collections.unmodifiableSet(this.unrequestedParameters);
    }

    public int getNumberOfParameters() {
        return this.data.size();
    }

    public String get(String key) {
        this.addToDefaults(key, null);
        this.unrequestedParameters.remove(key);
        return this.data.get(key);
    }

    public String getRequired(String key) {
        this.addToDefaults(key, null);
        String value = this.get(key);
        if (value == null) {
            throw new RuntimeException("No data for required key '" + key + "'");
        }
        return value;
    }

    public String get(String key, String defaultValue) {
        this.addToDefaults(key, defaultValue);
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean has(String value) {
        this.addToDefaults(value, null);
        this.unrequestedParameters.remove(value);
        return this.data.containsKey(value);
    }

    public int getInt(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Integer.parseInt(value);
    }

    public int getInt(String key, int defaultValue) {
        this.addToDefaults(key, Integer.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public long getLong(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Long.parseLong(value);
    }

    public long getLong(String key, long defaultValue) {
        this.addToDefaults(key, Long.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public float getFloat(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Float.valueOf(value).floatValue();
    }

    public float getFloat(String key, float defaultValue) {
        this.addToDefaults(key, Float.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Float.valueOf(value).floatValue();
    }

    public double getDouble(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Double.valueOf(value);
    }

    public double getDouble(String key, double defaultValue) {
        this.addToDefaults(key, Double.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Double.valueOf(value);
    }

    public boolean getBoolean(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Boolean.valueOf(value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        this.addToDefaults(key, Boolean.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public short getShort(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Short.valueOf(value);
    }

    public short getShort(String key, short defaultValue) {
        this.addToDefaults(key, Short.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Short.valueOf(value);
    }

    public byte getByte(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Byte.valueOf(value);
    }

    public byte getByte(String key, byte defaultValue) {
        this.addToDefaults(key, Byte.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Byte.valueOf(value);
    }

    protected void addToDefaults(String key, String value) {
        String currentValue = this.defaultData.get(key);
        if (currentValue == null) {
            if (value == null) {
                value = DEFAULT_UNDEFINED;
            }
            this.defaultData.put(key, value);
        } else if (currentValue.equals(DEFAULT_UNDEFINED) && value != null) {
            this.defaultData.put(key, value);
        }
    }

    public Configuration getConfiguration() {
        Configuration conf = new Configuration();
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            conf.setString(entry.getKey(), entry.getValue());
        }
        return conf;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll(this.data);
        return props;
    }

    public void createPropertiesFile(String pathToFile) throws IOException {
        this.createPropertiesFile(pathToFile, true);
    }

    public void createPropertiesFile(String pathToFile, boolean overwrite) throws IOException {
        File file = new File(pathToFile);
        if (file.exists()) {
            if (overwrite) {
                file.delete();
            } else {
                throw new RuntimeException("File " + pathToFile + " exists and overwriting is not allowed");
            }
        }
        Properties defaultProps = new Properties();
        defaultProps.putAll(this.defaultData);
        try (FileOutputStream out = new FileOutputStream(file);){
            defaultProps.store(out, "Default file created by Flink's ParameterUtil.createPropertiesFile()");
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ParameterTool(this.data);
    }

    public ParameterTool mergeWith(ParameterTool other) {
        HashMap<String, String> resultData = new HashMap<String, String>(this.data.size() + other.data.size());
        resultData.putAll(this.data);
        resultData.putAll(other.data);
        ParameterTool ret = new ParameterTool(resultData);
        HashSet<String> requestedParametersLeft = new HashSet<String>(this.data.keySet());
        requestedParametersLeft.removeAll(this.unrequestedParameters);
        HashSet<String> requestedParametersRight = new HashSet<String>(other.data.keySet());
        requestedParametersRight.removeAll(other.unrequestedParameters);
        ret.unrequestedParameters.removeAll(requestedParametersLeft);
        ret.unrequestedParameters.removeAll(requestedParametersRight);
        return ret;
    }

    public Map<String, String> toMap() {
        return this.data;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.defaultData = new ConcurrentHashMap<String, String>(this.data.size());
        this.unrequestedParameters = Collections.newSetFromMap(new ConcurrentHashMap(this.data.size()));
    }
}

