/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sampling;

import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.sampling.IntermediateSampleData;
import org.apache.flink.api.java.sampling.RandomSampler;
import org.apache.flink.api.java.sampling.SampledIterator;

@Internal
public abstract class DistributedRandomSampler<T>
extends RandomSampler<T> {
    protected final int numSamples;
    protected final Iterator<IntermediateSampleData<T>> emptyIntermediateIterable = new SampledIterator<IntermediateSampleData<T>>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public IntermediateSampleData<T> next() {
            return null;
        }
    };

    public DistributedRandomSampler(int numSamples) {
        this.numSamples = numSamples;
    }

    public abstract Iterator<IntermediateSampleData<T>> sampleInPartition(Iterator<T> var1);

    public Iterator<T> sampleInCoordinator(Iterator<IntermediateSampleData<T>> input) {
        if (this.numSamples == 0) {
            return this.emptyIterable;
        }
        PriorityQueue<IntermediateSampleData<T>> reservoir = new PriorityQueue<IntermediateSampleData<T>>(this.numSamples);
        int index = 0;
        IntermediateSampleData smallest = null;
        while (input.hasNext()) {
            IntermediateSampleData<T> element = input.next();
            if (index < this.numSamples) {
                reservoir.add(element);
                smallest = (IntermediateSampleData)reservoir.peek();
            } else if (element.getWeight() > smallest.getWeight()) {
                reservoir.remove();
                reservoir.add(element);
                smallest = (IntermediateSampleData)reservoir.peek();
            }
            ++index;
        }
        final Iterator itr = reservoir.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public T next() {
                return ((IntermediateSampleData)itr.next()).getElement();
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    @Override
    public Iterator<T> sample(Iterator<T> input) {
        return this.sampleInCoordinator(this.sampleInPartition(input));
    }
}

