/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;

@Internal
public class CompensatedSum
implements Serializable {
    private static final double NO_CORRECTION = 0.0;
    public static final CompensatedSum ZERO = new CompensatedSum(0.0, 0.0);
    private static final long serialVersionUID = 1L;
    private final double value;
    private final double delta;

    public CompensatedSum(double value, double delta) {
        this.value = value;
        this.delta = delta;
    }

    public double value() {
        return this.value;
    }

    public double delta() {
        return this.delta;
    }

    public CompensatedSum add(double value, double delta) {
        return this.add(new CompensatedSum(value, delta));
    }

    public CompensatedSum add(double value) {
        return this.add(new CompensatedSum(value, 0.0));
    }

    public CompensatedSum add(CompensatedSum other) {
        double correctedSum = other.value() + (this.delta + other.delta());
        double updatedValue = this.value + correctedSum;
        double updatedDelta = correctedSum - (updatedValue - this.value);
        return new CompensatedSum(updatedValue, updatedDelta);
    }
}

