/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import com.esotericsoftware.kryo.Serializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.CollectionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.RemoteEnvironment;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.hadoop.mapreduce.HadoopInputFormat;
import org.apache.flink.api.java.io.CollectionInputFormat;
import org.apache.flink.api.java.io.CsvReader;
import org.apache.flink.api.java.io.IteratorInputFormat;
import org.apache.flink.api.java.io.ParallelIteratorInputFormat;
import org.apache.flink.api.java.io.PrimitiveInputFormat;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.api.java.io.TextValueInputFormat;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.OperatorTranslation;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.com.google.common.base.Joiner;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.NumberSequenceIterator;
import org.apache.flink.util.SplittableIterator;
import org.apache.flink.util.Visitor;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionEnvironment.class);
    private static ExecutionEnvironmentFactory contextEnvironmentFactory;
    private static int defaultLocalDop;
    private static boolean allowLocalExecution;
    private final UUID executionId;
    private final List<DataSink<?>> sinks = new ArrayList();
    private final List<Tuple2<String, DistributedCache.DistributedCacheEntry>> cacheFile = new ArrayList<Tuple2<String, DistributedCache.DistributedCacheEntry>>();
    private final ExecutionConfig config = new ExecutionConfig();
    protected JobExecutionResult lastJobExecutionResult;
    private boolean wasExecuted = false;

    protected ExecutionEnvironment() {
        this.executionId = UUID.randomUUID();
    }

    public ExecutionConfig getConfig() {
        return this.config;
    }

    @Deprecated
    public int getDegreeOfParallelism() {
        return this.getParallelism();
    }

    public int getParallelism() {
        return this.config.getParallelism();
    }

    @Deprecated
    public void setDegreeOfParallelism(int parallelism) {
        this.setParallelism(parallelism);
    }

    public void setParallelism(int parallelism) {
        this.config.setParallelism(parallelism);
    }

    public void setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        this.config.setNumberOfExecutionRetries(numberOfExecutionRetries);
    }

    public int getNumberOfExecutionRetries() {
        return this.config.getNumberOfExecutionRetries();
    }

    public UUID getId() {
        return this.executionId;
    }

    public JobExecutionResult getLastJobExecutionResult() {
        return this.lastJobExecutionResult;
    }

    public String getIdString() {
        return this.executionId.toString();
    }

    public void addDefaultKryoSerializer(Class<?> type, Serializer<?> serializer) {
        this.config.addDefaultKryoSerializer(type, serializer);
    }

    public void addDefaultKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        this.config.addDefaultKryoSerializer(type, serializerClass);
    }

    public void registerTypeWithKryoSerializer(Class<?> type, Serializer<?> serializer) {
        this.config.registerTypeWithKryoSerializer(type, serializer);
    }

    public void registerTypeWithKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        this.config.registerTypeWithKryoSerializer(type, serializerClass);
    }

    public void registerType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        TypeInformation<?> typeInfo = TypeExtractor.createTypeInfo(type);
        if (typeInfo instanceof PojoTypeInfo) {
            this.config.registerPojoType(type);
        } else {
            this.config.registerKryoType(type);
        }
    }

    public DataSource<String> readTextFile(String filePath) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        return new DataSource<String>(this, (org.apache.flink.api.common.io.InputFormat<String, ?>)new TextInputFormat(new Path(filePath)), (TypeInformation<String>)BasicTypeInfo.STRING_TYPE_INFO, Utils.getCallLocationName());
    }

    public DataSource<String> readTextFile(String filePath, String charsetName) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        TextInputFormat format = new TextInputFormat(new Path(filePath));
        format.setCharsetName(charsetName);
        return new DataSource<String>(this, (org.apache.flink.api.common.io.InputFormat<String, ?>)format, (TypeInformation<String>)BasicTypeInfo.STRING_TYPE_INFO, Utils.getCallLocationName());
    }

    public DataSource<StringValue> readTextFileWithValue(String filePath) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        return new DataSource<StringValue>(this, (org.apache.flink.api.common.io.InputFormat<StringValue, ?>)new TextValueInputFormat(new Path(filePath)), (TypeInformation<StringValue>)new ValueTypeInfo<StringValue>(StringValue.class), Utils.getCallLocationName());
    }

    public DataSource<StringValue> readTextFileWithValue(String filePath, String charsetName, boolean skipInvalidLines) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        TextValueInputFormat format = new TextValueInputFormat(new Path(filePath));
        format.setCharsetName(charsetName);
        format.setSkipInvalidLines(skipInvalidLines);
        return new DataSource<StringValue>(this, (org.apache.flink.api.common.io.InputFormat<StringValue, ?>)format, (TypeInformation<StringValue>)new ValueTypeInfo<StringValue>(StringValue.class), Utils.getCallLocationName());
    }

    public <X> DataSource<X> readFileOfPrimitives(String filePath, Class<X> typeClass) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        return new DataSource<X>(this, new PrimitiveInputFormat<X>(new Path(filePath), typeClass), TypeExtractor.getForClass(typeClass), Utils.getCallLocationName());
    }

    public <X> DataSource<X> readFileOfPrimitives(String filePath, String delimiter, Class<X> typeClass) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        return new DataSource<X>(this, new PrimitiveInputFormat<X>(new Path(filePath), delimiter, typeClass), TypeExtractor.getForClass(typeClass), Utils.getCallLocationName());
    }

    public CsvReader readCsvFile(String filePath) {
        return new CsvReader(filePath, this);
    }

    public <X> DataSource<X> readFile(FileInputFormat<X> inputFormat, String filePath) {
        if (inputFormat == null) {
            throw new IllegalArgumentException("InputFormat must not be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("The file path must not be null.");
        }
        inputFormat.setFilePath(new Path(filePath));
        try {
            return this.createInput((org.apache.flink.api.common.io.InputFormat<X, ?>)inputFormat, (TypeInformation<X>)TypeExtractor.getInputFormatTypes(inputFormat));
        }
        catch (Exception e) {
            throw new InvalidProgramException("The type returned by the input format could not be automatically determined. Please specify the TypeInformation of the produced type explicitly by using the 'createInput(InputFormat, TypeInformation)' method instead.");
        }
    }

    public <X> DataSource<X> createInput(org.apache.flink.api.common.io.InputFormat<X, ?> inputFormat) {
        if (inputFormat == null) {
            throw new IllegalArgumentException("InputFormat must not be null.");
        }
        try {
            return this.createInput(inputFormat, TypeExtractor.getInputFormatTypes(inputFormat));
        }
        catch (Exception e) {
            throw new InvalidProgramException("The type returned by the input format could not be automatically determined. Please specify the TypeInformation of the produced type explicitly by using the 'createInput(InputFormat, TypeInformation)' method instead.");
        }
    }

    public <X> DataSource<X> createInput(org.apache.flink.api.common.io.InputFormat<X, ?> inputFormat, TypeInformation<X> producedType) {
        if (inputFormat == null) {
            throw new IllegalArgumentException("InputFormat must not be null.");
        }
        if (producedType == null) {
            throw new IllegalArgumentException("Produced type information must not be null.");
        }
        return new DataSource<X>(this, inputFormat, producedType, Utils.getCallLocationName());
    }

    public <K, V> DataSource<Tuple2<K, V>> readHadoopFile(org.apache.hadoop.mapred.FileInputFormat<K, V> mapredInputFormat, Class<K> key, Class<V> value, String inputPath, JobConf job) {
        DataSource<Tuple2<K, V>> result = this.createHadoopInput((org.apache.hadoop.mapred.InputFormat<K, V>)mapredInputFormat, key, value, job);
        org.apache.hadoop.mapred.FileInputFormat.addInputPath((JobConf)job, (org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(inputPath));
        return result;
    }

    public <K, V> DataSource<Tuple2<K, V>> readHadoopFile(org.apache.hadoop.mapred.FileInputFormat<K, V> mapredInputFormat, Class<K> key, Class<V> value, String inputPath) {
        return this.readHadoopFile(mapredInputFormat, key, value, inputPath, new JobConf());
    }

    public <K, V> DataSource<Tuple2<K, V>> createHadoopInput(org.apache.hadoop.mapred.InputFormat<K, V> mapredInputFormat, Class<K> key, Class<V> value, JobConf job) {
        org.apache.flink.api.java.hadoop.mapred.HadoopInputFormat<K, V> hadoopInputFormat = new org.apache.flink.api.java.hadoop.mapred.HadoopInputFormat<K, V>(mapredInputFormat, key, value, job);
        return this.createInput(hadoopInputFormat);
    }

    public <K, V> DataSource<Tuple2<K, V>> readHadoopFile(org.apache.hadoop.mapreduce.lib.input.FileInputFormat<K, V> mapreduceInputFormat, Class<K> key, Class<V> value, String inputPath, Job job) throws IOException {
        DataSource<Tuple2<K, V>> result = this.createHadoopInput((InputFormat<K, V>)mapreduceInputFormat, key, value, job);
        org.apache.hadoop.mapreduce.lib.input.FileInputFormat.addInputPath((Job)job, (org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(inputPath));
        return result;
    }

    public <K, V> DataSource<Tuple2<K, V>> readHadoopFile(org.apache.hadoop.mapreduce.lib.input.FileInputFormat<K, V> mapreduceInputFormat, Class<K> key, Class<V> value, String inputPath) throws IOException {
        return this.readHadoopFile(mapreduceInputFormat, key, value, inputPath, Job.getInstance());
    }

    public <K, V> DataSource<Tuple2<K, V>> createHadoopInput(InputFormat<K, V> mapreduceInputFormat, Class<K> key, Class<V> value, Job job) {
        HadoopInputFormat<K, V> hadoopInputFormat = new HadoopInputFormat<K, V>(mapreduceInputFormat, key, value, job);
        return this.createInput(hadoopInputFormat);
    }

    public <X> DataSource<X> fromCollection(Collection<X> data) {
        if (data == null) {
            throw new IllegalArgumentException("The data must not be null.");
        }
        if (data.size() == 0) {
            throw new IllegalArgumentException("The size of the collection must not be empty.");
        }
        X firstValue = data.iterator().next();
        TypeInformation<X> type = TypeExtractor.getForObject(firstValue);
        CollectionInputFormat.checkCollection(data, type.getTypeClass());
        return new DataSource<X>(this, new CollectionInputFormat<X>(data, type.createSerializer(this.config)), type, Utils.getCallLocationName());
    }

    public <X> DataSource<X> fromCollection(Collection<X> data, TypeInformation<X> type) {
        return this.fromCollection(data, type, Utils.getCallLocationName());
    }

    private <X> DataSource<X> fromCollection(Collection<X> data, TypeInformation<X> type, String callLocationName) {
        CollectionInputFormat.checkCollection(data, type.getTypeClass());
        return new DataSource<X>(this, new CollectionInputFormat<X>(data, type.createSerializer(this.config)), type, callLocationName);
    }

    public <X> DataSource<X> fromCollection(Iterator<X> data, Class<X> type) {
        return this.fromCollection(data, TypeExtractor.getForClass(type));
    }

    public <X> DataSource<X> fromCollection(Iterator<X> data, TypeInformation<X> type) {
        return new DataSource<X>(this, new IteratorInputFormat<X>(data), type, Utils.getCallLocationName());
    }

    public <X> DataSource<X> fromElements(X ... data) {
        if (data == null) {
            throw new IllegalArgumentException("The data must not be null.");
        }
        if (data.length == 0) {
            throw new IllegalArgumentException("The number of elements must not be zero.");
        }
        return this.fromCollection(Arrays.asList(data), TypeExtractor.getForObject(data[0]), Utils.getCallLocationName());
    }

    public <X> DataSource<X> fromParallelCollection(SplittableIterator<X> iterator, Class<X> type) {
        return this.fromParallelCollection(iterator, TypeExtractor.getForClass(type));
    }

    public <X> DataSource<X> fromParallelCollection(SplittableIterator<X> iterator, TypeInformation<X> type) {
        return this.fromParallelCollection(iterator, type, Utils.getCallLocationName());
    }

    private <X> DataSource<X> fromParallelCollection(SplittableIterator<X> iterator, TypeInformation<X> type, String callLocationName) {
        return new DataSource<X>(this, new ParallelIteratorInputFormat<X>(iterator), type, callLocationName);
    }

    public DataSource<Long> generateSequence(long from, long to) {
        return this.fromParallelCollection((SplittableIterator)new NumberSequenceIterator(from, to), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, Utils.getCallLocationName());
    }

    public JobExecutionResult execute() throws Exception {
        return this.execute(ExecutionEnvironment.getDefaultName());
    }

    public abstract JobExecutionResult execute(String var1) throws Exception;

    public abstract String getExecutionPlan() throws Exception;

    public void registerCachedFile(String filePath, String name) {
        this.registerCachedFile(filePath, name, false);
    }

    public void registerCachedFile(String filePath, String name, boolean executable) {
        this.cacheFile.add(new Tuple2<String, DistributedCache.DistributedCacheEntry>(name, new DistributedCache.DistributedCacheEntry(filePath, Boolean.valueOf(executable))));
    }

    protected void registerCachedFilesWithPlan(Plan p) throws IOException {
        for (Tuple2<String, DistributedCache.DistributedCacheEntry> entry : this.cacheFile) {
            p.registerCachedFile((String)entry.f0, (DistributedCache.DistributedCacheEntry)entry.f1);
        }
    }

    public JavaPlan createProgramPlan() {
        return this.createProgramPlan(null);
    }

    public JavaPlan createProgramPlan(String jobName) {
        return this.createProgramPlan(jobName, true);
    }

    public JavaPlan createProgramPlan(String jobName, boolean clearSinks) {
        if (this.sinks.isEmpty()) {
            if (this.wasExecuted) {
                throw new RuntimeException("No new data sinks have been defined since the last execution. The last execution refers to the latest call to 'execute()', 'count()', 'collect()', or 'print()'.");
            }
            throw new RuntimeException("No data sinks have been created yet. A program needs at least one sink that consumes data. Examples are writing the data set or printing it.");
        }
        if (jobName == null) {
            jobName = ExecutionEnvironment.getDefaultName();
        }
        OperatorTranslation translator = new OperatorTranslation();
        JavaPlan plan = translator.translateToPlan(this.sinks, jobName);
        if (this.getParallelism() > 0) {
            plan.setDefaultParallelism(this.getParallelism());
        }
        plan.setExecutionConfig(this.getConfig());
        plan.accept(new Visitor<Operator<?>>(){

            public boolean preVisit(Operator<?> visitable) {
                OperatorInformation opInfo = visitable.getOperatorInfo();
                TypeInformation typeInfo = opInfo.getOutputType();
                if (typeInfo instanceof GenericTypeInfo) {
                    GenericTypeInfo genericTypeInfo = (GenericTypeInfo)typeInfo;
                    if (!ExecutionEnvironment.this.config.isAutoTypeRegistrationDisabled()) {
                        Serializers.recursivelyRegisterType(genericTypeInfo.getTypeClass(), ExecutionEnvironment.this.config);
                    }
                }
                if (typeInfo instanceof CompositeType) {
                    ArrayList genericTypesInComposite = new ArrayList();
                    Utils.getContainedGenericTypes((CompositeType)typeInfo, genericTypesInComposite);
                    for (GenericTypeInfo genericTypeInfo : genericTypesInComposite) {
                        Serializers.recursivelyRegisterType(genericTypeInfo.getTypeClass(), ExecutionEnvironment.this.config);
                    }
                }
                return true;
            }

            public void postVisit(Operator<?> visitable) {
            }
        });
        try {
            this.registerCachedFilesWithPlan(plan);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while registering cached files: " + e.getMessage(), e);
        }
        if (clearSinks) {
            this.sinks.clear();
            this.wasExecuted = true;
        }
        int registeredTypes = this.config.getRegisteredKryoTypes().size() + this.config.getRegisteredPojoTypes().size() + this.config.getRegisteredTypesWithKryoSerializerClasses().size() + this.config.getRegisteredTypesWithKryoSerializers().size();
        int defaultKryoSerializers = this.config.getDefaultKryoSerializers().size() + this.config.getDefaultKryoSerializerClasses().size();
        LOG.info("The job has {} registered types and {} default Kryo serializers", (Object)registeredTypes, (Object)defaultKryoSerializers);
        if (this.config.isForceKryoEnabled() && this.config.isForceAvroEnabled()) {
            LOG.warn("In the ExecutionConfig, both Avro and Kryo are enforced. Using Kryo serializer");
        }
        if (this.config.isForceKryoEnabled()) {
            LOG.info("Using KryoSerializer for serializing POJOs");
        }
        if (this.config.isForceAvroEnabled()) {
            LOG.info("Using AvroSerializer for serializing POJOs");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered Kryo types: {}", (Object)Joiner.on(',').join(this.config.getRegisteredKryoTypes()));
            LOG.debug("Registered Kryo with Serializers types: {}", (Object)Joiner.on(',').join(this.config.getRegisteredTypesWithKryoSerializers()));
            LOG.debug("Registered Kryo with Serializer Classes types: {}", (Object)Joiner.on(',').join(this.config.getRegisteredTypesWithKryoSerializerClasses()));
            LOG.debug("Registered Kryo default Serializers: {}", (Object)Joiner.on(',').join(this.config.getDefaultKryoSerializers()));
            LOG.debug("Registered Kryo default Serializers Classes {}", (Object)Joiner.on(',').join(this.config.getDefaultKryoSerializerClasses()));
            LOG.debug("Registered POJO types: {}", (Object)Joiner.on(',').join(this.config.getRegisteredPojoTypes()));
            LOG.debug("Static code analysis mode: {}", (Object)this.config.getCodeAnalysisMode());
        }
        return plan;
    }

    void registerDataSink(DataSink<?> sink) {
        this.sinks.add(sink);
    }

    private static String getDefaultName() {
        return "Flink Java Job at " + Calendar.getInstance().getTime();
    }

    public static ExecutionEnvironment getExecutionEnvironment() {
        return contextEnvironmentFactory == null ? ExecutionEnvironment.createLocalEnvironment() : contextEnvironmentFactory.createExecutionEnvironment();
    }

    public static CollectionEnvironment createCollectionsEnvironment() {
        CollectionEnvironment ce = new CollectionEnvironment();
        ce.setParallelism(1);
        return ce;
    }

    public static LocalEnvironment createLocalEnvironment() {
        return ExecutionEnvironment.createLocalEnvironment(defaultLocalDop);
    }

    public static LocalEnvironment createLocalEnvironment(int parallelism) {
        LocalEnvironment lee = new LocalEnvironment();
        lee.setParallelism(parallelism);
        return lee;
    }

    public static LocalEnvironment createLocalEnvironment(Configuration customConfiguration) {
        LocalEnvironment lee = new LocalEnvironment();
        lee.setConfiguration(customConfiguration);
        return lee;
    }

    public static ExecutionEnvironment createRemoteEnvironment(String host, int port, String ... jarFiles) {
        return new RemoteEnvironment(host, port, jarFiles);
    }

    public static ExecutionEnvironment createRemoteEnvironment(String host, int port, int parallelism, String ... jarFiles) {
        RemoteEnvironment rec = new RemoteEnvironment(host, port, jarFiles);
        rec.setParallelism(parallelism);
        return rec;
    }

    public static void setDefaultLocalParallelism(int parallelism) {
        defaultLocalDop = parallelism;
    }

    protected static void initializeContextEnvironment(ExecutionEnvironmentFactory ctx) {
        contextEnvironmentFactory = ctx;
    }

    protected static boolean isContextEnvironmentSet() {
        return contextEnvironmentFactory != null;
    }

    protected static void enableLocalExecution(boolean enabled) {
        allowLocalExecution = enabled;
    }

    public static boolean localExecutionIsAllowed() {
        return allowLocalExecution;
    }

    static {
        defaultLocalDop = Runtime.getRuntime().availableProcessors();
        allowLocalExecution = true;
    }
}

