/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.runtime.PojoComparator;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.shaded.com.google.common.base.Joiner;

public class PojoTypeInfo<T>
extends CompositeType<T> {
    private static final long serialVersionUID = 1L;
    private static final String REGEX_FIELD = "[\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*";
    private static final String REGEX_NESTED_FIELDS = "([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?";
    private static final String REGEX_NESTED_FIELDS_WILDCARD = "([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?|\\*|\\_";
    private static final Pattern PATTERN_NESTED_FIELDS = Pattern.compile("([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?");
    private static final Pattern PATTERN_NESTED_FIELDS_WILDCARD = Pattern.compile("([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?|\\*|\\_");
    private final Class<T> typeClass;
    private PojoField[] fields;
    private int totalFields;
    private TypeComparator<?>[] fieldComparators;
    private Field[] keyFields;
    private int comparatorHelperIndex = 0;

    public PojoTypeInfo(Class<T> typeClass, List<PojoField> fields) {
        super(typeClass);
        this.typeClass = typeClass;
        ArrayList<PojoField> tempFields = new ArrayList<PojoField>(fields);
        Collections.sort(tempFields, new Comparator<PojoField>(){

            @Override
            public int compare(PojoField o1, PojoField o2) {
                return o1.field.getName().compareTo(o2.field.getName());
            }
        });
        this.fields = tempFields.toArray(new PojoField[tempFields.size()]);
        if (!Modifier.isPublic(typeClass.getModifiers())) {
            throw new RuntimeException("POJO " + typeClass + " is not public");
        }
        for (PojoField field : fields) {
            this.totalFields += field.type.getTotalFields();
        }
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return this.fields.length;
    }

    public int getTotalFields() {
        return this.totalFields;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public boolean isSortKeyType() {
        return false;
    }

    public void getFlatFields(String fieldExpression, int offset, List<CompositeType.FlatFieldDescriptor> result) {
        Matcher matcher = PATTERN_NESTED_FIELDS_WILDCARD.matcher(fieldExpression);
        if (!matcher.matches()) {
            throw new CompositeType.InvalidFieldReferenceException("Invalid POJO field reference \"" + fieldExpression + "\".");
        }
        String field = matcher.group(0);
        if (field.equals("*") || field.equals("_")) {
            int keyPosition = 0;
            for (PojoField pField : this.fields) {
                if (pField.type instanceof CompositeType) {
                    CompositeType cType = (CompositeType)pField.type;
                    cType.getFlatFields(String.valueOf("*"), offset + keyPosition, result);
                    keyPosition += cType.getTotalFields() - 1;
                } else {
                    result.add(new NamedFlatFieldDescriptor(pField.field.getName(), offset + keyPosition, pField.type));
                }
                ++keyPosition;
            }
            return;
        }
        field = matcher.group(1);
        int fieldPos = -1;
        TypeInformation<?> fieldType = null;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].field.getName().equals(field)) continue;
            fieldPos = i;
            fieldType = this.fields[i].type;
            break;
        }
        if (fieldPos == -1) {
            throw new CompositeType.InvalidFieldReferenceException("Unable to find field \"" + field + "\" in type " + (Object)((Object)this) + ".");
        }
        String tail = matcher.group(3);
        if (tail == null) {
            if (fieldType instanceof CompositeType) {
                for (int i = 0; i < fieldPos; ++i) {
                    offset += this.getTypeAt(i).getTotalFields();
                }
                ((CompositeType)fieldType).getFlatFields("*", offset, result);
                return;
            }
            int flatFieldPos = offset;
            for (int i = 0; i < fieldPos; ++i) {
                flatFieldPos += this.getTypeAt(i).getTotalFields();
            }
            result.add(new CompositeType.FlatFieldDescriptor(flatFieldPos, fieldType));
            return;
        }
        if (fieldType instanceof CompositeType) {
            for (int i = 0; i < fieldPos; ++i) {
                offset += this.getTypeAt(i).getTotalFields();
            }
            ((CompositeType)fieldType).getFlatFields(tail, offset, result);
            return;
        }
        throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
    }

    public <X> TypeInformation<X> getTypeAt(String fieldExpression) {
        Matcher matcher = PATTERN_NESTED_FIELDS.matcher(fieldExpression);
        if (!matcher.matches()) {
            if (fieldExpression.startsWith("*") || fieldExpression.startsWith("_")) {
                throw new CompositeType.InvalidFieldReferenceException("Wildcard expressions are not allowed here.");
            }
            throw new CompositeType.InvalidFieldReferenceException("Invalid format of POJO field expression \"" + fieldExpression + "\".");
        }
        String field = matcher.group(1);
        int fieldPos = -1;
        TypeInformation<?> fieldType = null;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].field.getName().equals(field)) continue;
            fieldPos = i;
            fieldType = this.fields[i].type;
            break;
        }
        if (fieldPos == -1) {
            throw new CompositeType.InvalidFieldReferenceException("Unable to find field \"" + field + "\" in type " + (Object)((Object)this) + ".");
        }
        String tail = matcher.group(3);
        if (tail == null) {
            return fieldType;
        }
        if (fieldType instanceof CompositeType) {
            return ((CompositeType)fieldType).getTypeAt(tail);
        }
        throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
    }

    public <X> TypeInformation<X> getTypeAt(int pos) {
        if (pos < 0 || pos >= this.fields.length) {
            throw new IndexOutOfBoundsException();
        }
        TypeInformation<?> typed = this.fields[pos].type;
        return typed;
    }

    public PojoField getPojoFieldAt(int pos) {
        if (pos < 0 || pos >= this.fields.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.fields[pos];
    }

    protected void initializeNewComparator(int keyCount) {
        this.fieldComparators = new TypeComparator[keyCount];
        this.keyFields = new Field[keyCount];
        this.comparatorHelperIndex = 0;
    }

    protected void addCompareField(int fieldId, TypeComparator<?> comparator) {
        this.fieldComparators[this.comparatorHelperIndex] = comparator;
        this.keyFields[this.comparatorHelperIndex] = this.fields[fieldId].field;
        ++this.comparatorHelperIndex;
    }

    protected TypeComparator<T> getNewComparator(ExecutionConfig config) {
        Field[] finalKeyFields = Arrays.copyOf(this.keyFields, this.comparatorHelperIndex);
        TypeComparator<?>[] finalFieldComparators = Arrays.copyOf(this.fieldComparators, this.comparatorHelperIndex);
        if (finalFieldComparators.length == 0 || finalKeyFields.length == 0 || finalFieldComparators.length != finalKeyFields.length) {
            throw new IllegalArgumentException("Pojo comparator creation has a bug");
        }
        return new PojoComparator<T>(finalKeyFields, finalFieldComparators, this.createSerializer(config), this.typeClass);
    }

    public String[] getFieldNames() {
        String[] result = new String[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            result[i] = this.fields[i].field.getName();
        }
        return result;
    }

    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].field.getName().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        TypeSerializer[] fieldSerializers = new TypeSerializer[this.fields.length];
        Field[] reflectiveFields = new Field[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            fieldSerializers[i] = this.fields[i].type.createSerializer(config);
            reflectiveFields[i] = this.fields[i].field;
        }
        return new PojoSerializer<T>(this.typeClass, fieldSerializers, reflectiveFields, config);
    }

    public boolean equals(Object obj) {
        return obj instanceof PojoTypeInfo && ((PojoTypeInfo)((Object)obj)).typeClass == this.typeClass;
    }

    public int hashCode() {
        return this.typeClass.hashCode() + 1387562934;
    }

    public String toString() {
        ArrayList<String> fieldStrings = new ArrayList<String>();
        for (PojoField field : this.fields) {
            fieldStrings.add(field.field.getName() + ": " + field.type.toString());
        }
        return "PojoType<" + this.typeClass.getName() + ", fields = [" + Joiner.on(", ").join(fieldStrings) + "]" + ">";
    }

    public static class NamedFlatFieldDescriptor
    extends CompositeType.FlatFieldDescriptor {
        private String fieldName;

        public NamedFlatFieldDescriptor(String name, int keyPosition, TypeInformation<?> type) {
            super(keyPosition, type);
            this.fieldName = name;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String toString() {
            return "NamedFlatFieldDescriptor [name=" + this.fieldName + " position=" + this.getPosition() + " typeInfo=" + this.getType() + "]";
        }
    }
}

