/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.translation.Tuple3UnwrappingIterator;
import org.apache.flink.api.java.operators.translation.Tuple3WrappingCollector;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.util.Collector;

public class PlanUnwrappingSortedReduceGroupOperator<IN, OUT, K1, K2>
extends GroupReduceOperatorBase<Tuple3<K1, K2, IN>, OUT, GroupReduceFunction<Tuple3<K1, K2, IN>, OUT>> {
    public PlanUnwrappingSortedReduceGroupOperator(GroupReduceFunction<IN, OUT> udf, Keys.SelectorFunctionKeys<IN, K1> groupingKey, Keys.SelectorFunctionKeys<IN, K2> sortingKey, String name, TypeInformation<OUT> outType, TypeInformation<Tuple3<K1, K2, IN>> typeInfoWithKey, boolean combinable) {
        super((GroupReduceFunction)(combinable ? new TupleUnwrappingGroupCombinableGroupReducer((RichGroupReduceFunction)udf) : new TupleUnwrappingNonCombinableGroupReducer(udf)), new UnaryOperatorInformation(typeInfoWithKey, outType), groupingKey.computeLogicalKeyPositions(), name);
        super.setCombinable(combinable);
    }

    public static final class TupleUnwrappingNonCombinableGroupReducer<IN, OUT, K1, K2>
    extends WrappingFunction<GroupReduceFunction<IN, OUT>>
    implements GroupReduceFunction<Tuple3<K1, K2, IN>, OUT> {
        private static final long serialVersionUID = 1L;
        private final Tuple3UnwrappingIterator<IN, K1, K2> iter = new Tuple3UnwrappingIterator();

        private TupleUnwrappingNonCombinableGroupReducer(GroupReduceFunction<IN, OUT> wrapped) {
            super(wrapped);
        }

        public void reduce(Iterable<Tuple3<K1, K2, IN>> values, Collector<OUT> out) throws Exception {
            this.iter.set(values.iterator());
            ((GroupReduceFunction)this.wrappedFunction).reduce(this.iter, out);
        }

        public String toString() {
            return ((GroupReduceFunction)this.wrappedFunction).toString();
        }
    }

    @RichGroupReduceFunction.Combinable
    public static final class TupleUnwrappingGroupCombinableGroupReducer<IN, OUT, K1, K2>
    extends WrappingFunction<RichGroupReduceFunction<IN, OUT>>
    implements GroupReduceFunction<Tuple3<K1, K2, IN>, OUT>,
    GroupCombineFunction<Tuple3<K1, K2, IN>, Tuple3<K1, K2, IN>> {
        private static final long serialVersionUID = 1L;
        private Tuple3UnwrappingIterator<IN, K1, K2> iter = new Tuple3UnwrappingIterator();
        private Tuple3WrappingCollector<IN, K1, K2> coll = new Tuple3WrappingCollector<IN, K1, K2>(this.iter);

        private TupleUnwrappingGroupCombinableGroupReducer(RichGroupReduceFunction<IN, OUT> wrapped) {
            super(wrapped);
        }

        public void reduce(Iterable<Tuple3<K1, K2, IN>> values, Collector<OUT> out) throws Exception {
            this.iter.set(values.iterator());
            ((RichGroupReduceFunction)this.wrappedFunction).reduce(this.iter, out);
        }

        public void combine(Iterable<Tuple3<K1, K2, IN>> values, Collector<Tuple3<K1, K2, IN>> out) throws Exception {
            this.iter.set(values.iterator());
            this.coll.set(out);
            ((RichGroupReduceFunction)this.wrappedFunction).combine(this.iter, this.coll);
        }

        public String toString() {
            return ((RichGroupReduceFunction)this.wrappedFunction).toString();
        }
    }
}

