/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.TwoInputOperator;
import org.apache.flink.api.java.operators.UdfOperator;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.configuration.Configuration;

public abstract class TwoInputUdfOperator<IN1, IN2, OUT, O extends TwoInputUdfOperator<IN1, IN2, OUT, O>>
extends TwoInputOperator<IN1, IN2, OUT, O>
implements UdfOperator<O> {
    private Configuration parameters;
    private Map<String, DataSet<?>> broadcastVariables;
    private DualInputSemanticProperties udfSemantics;

    protected TwoInputUdfOperator(DataSet<IN1> input1, DataSet<IN2> input2, TypeInformation<OUT> resultType) {
        super(input1, input2, resultType);
    }

    protected abstract Function getFunction();

    @Override
    public O withParameters(Configuration parameters) {
        this.parameters = parameters;
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    @Override
    public O withBroadcastSet(DataSet<?> data, String name) {
        if (data == null) {
            throw new IllegalArgumentException("Broadcast variable data must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Broadcast variable name must not be null.");
        }
        if (this.broadcastVariables == null) {
            this.broadcastVariables = new HashMap();
        }
        this.broadcastVariables.put(name, data);
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O withForwardedFieldsFirst(String ... forwardedFieldsFirst) {
        if (this.udfSemantics == null) {
            this.udfSemantics = this.extractSemanticAnnotationsFromUdf(this.getFunction().getClass());
        }
        if (this.udfSemantics == null) {
            this.udfSemantics = new DualInputSemanticProperties();
            SemanticPropUtil.getSemanticPropsDualFromString(this.udfSemantics, forwardedFieldsFirst, null, null, null, null, null, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        } else {
            if (this.udfWithForwardedFieldsFirstAnnotation(this.getFunction().getClass())) {
                throw new SemanticProperties.InvalidSemanticAnnotationException("Forwarded field information has already been added by a function annotation for the first input of this operator. Cannot overwrite function annotations.");
            }
            SemanticPropUtil.getSemanticPropsDualFromString(this.udfSemantics, forwardedFieldsFirst, null, null, null, null, null, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        }
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O withForwardedFieldsSecond(String ... forwardedFieldsSecond) {
        if (this.udfSemantics == null) {
            this.udfSemantics = this.extractSemanticAnnotationsFromUdf(this.getFunction().getClass());
        }
        if (this.udfSemantics == null) {
            this.udfSemantics = new DualInputSemanticProperties();
            SemanticPropUtil.getSemanticPropsDualFromString(this.udfSemantics, null, forwardedFieldsSecond, null, null, null, null, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        } else {
            if (this.udfWithForwardedFieldsSecondAnnotation(this.getFunction().getClass())) {
                throw new SemanticProperties.InvalidSemanticAnnotationException("Forwarded field information has already been added by a function annotation for the second input of this operator. Cannot overwrite function annotations.");
            }
            SemanticPropUtil.getSemanticPropsDualFromString(this.udfSemantics, null, forwardedFieldsSecond, null, null, null, null, this.getInput1Type(), this.getInput2Type(), this.getResultType());
        }
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O returns(String typeInfoString) {
        if (typeInfoString == null) {
            throw new IllegalArgumentException("Type information string must not be null.");
        }
        return this.returns(TypeInfoParser.parse(typeInfoString));
    }

    public O returns(TypeInformation<OUT> typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Type information must not be null.");
        }
        this.fillInType(typeInfo);
        TwoInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O returns(Class<OUT> typeClass) {
        if (typeClass == null) {
            throw new IllegalArgumentException("Type class must not be null.");
        }
        try {
            TypeInformation<?> ti = TypeExtractor.createTypeInfo(typeClass);
            return this.returns(ti);
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("The given class is not suited for providing necessary type information.", (Throwable)e);
        }
    }

    @Override
    public Map<String, DataSet<?>> getBroadcastSets() {
        return this.broadcastVariables == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.broadcastVariables);
    }

    @Override
    public Configuration getParameters() {
        return this.parameters;
    }

    public DualInputSemanticProperties getSemanticProperties() {
        if (this.udfSemantics == null) {
            DualInputSemanticProperties props = this.extractSemanticAnnotationsFromUdf(this.getFunction().getClass());
            this.udfSemantics = props != null ? props : new DualInputSemanticProperties();
        }
        return this.udfSemantics;
    }

    public void setSemanticProperties(DualInputSemanticProperties properties) {
        this.udfSemantics = properties;
    }

    protected DualInputSemanticProperties extractSemanticAnnotationsFromUdf(Class<?> udfClass) {
        Set<Annotation> annotations = FunctionAnnotation.readDualForwardAnnotations(udfClass);
        return SemanticPropUtil.getSemanticPropsDual(annotations, this.getInput1Type(), this.getInput2Type(), this.getResultType());
    }

    protected boolean udfWithForwardedFieldsFirstAnnotation(Class<?> udfClass) {
        return udfClass.getAnnotation(FunctionAnnotation.ForwardedFieldsFirst.class) != null || udfClass.getAnnotation(FunctionAnnotation.NonForwardedFieldsFirst.class) != null;
    }

    protected boolean udfWithForwardedFieldsSecondAnnotation(Class<?> udfClass) {
        return udfClass.getAnnotation(FunctionAnnotation.ForwardedFieldsSecond.class) != null || udfClass.getAnnotation(FunctionAnnotation.NonForwardedFieldsSecond.class) != null;
    }
}

