/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.CrossOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class CrossOperator<I1, I2, OUT>
extends TwoInputUdfOperator<I1, I2, OUT, CrossOperator<I1, I2, OUT>> {
    private final CrossFunction<I1, I2, OUT> function;
    private final String defaultName;
    private final CrossOperatorBase.CrossHint hint;

    public CrossOperator(DataSet<I1> input1, DataSet<I2> input2, CrossFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType, CrossOperatorBase.CrossHint hint, String defaultName) {
        super(input1, input2, returnType);
        this.function = function;
        this.defaultName = defaultName;
        this.hint = hint;
    }

    protected CrossFunction<I1, I2, OUT> getFunction() {
        return this.function;
    }

    public CrossOperatorBase.CrossHint getCrossHint() {
        return this.hint;
    }

    private String getDefaultName() {
        return this.defaultName;
    }

    protected CrossOperatorBase<I1, I2, OUT, CrossFunction<I1, I2, OUT>> translateToDataFlow(Operator<I1> input1, Operator<I2> input2) {
        String name = this.getName() != null ? this.getName() : "Cross at " + this.defaultName;
        CrossOperatorBase po = new CrossOperatorBase(this.function, new BinaryOperatorInformation(this.getInput1Type(), this.getInput2Type(), this.getResultType()), name);
        po.setFirstInput(input1);
        po.setSecondInput(input2);
        po.setParallelism(this.getParallelism());
        po.setCrossHint(this.hint);
        return po;
    }

    public static final class DefaultCrossFunction<T1, T2>
    implements CrossFunction<T1, T2, Tuple2<T1, T2>> {
        private static final long serialVersionUID = 1L;
        private final Tuple2<T1, T2> outTuple = new Tuple2();

        public Tuple2<T1, T2> cross(T1 first, T2 second) throws Exception {
            this.outTuple.f0 = first;
            this.outTuple.f1 = second;
            return this.outTuple;
        }
    }

    public static final class CrossProjection<I1, I2> {
        private final DataSet<I1> ds1;
        private final DataSet<I2> ds2;
        private int[] fieldIndexes;
        private boolean[] isFieldInFirst;
        private final int numFieldsDs1;
        private final int numFieldsDs2;
        private final CrossOperatorBase.CrossHint hint;

        public CrossProjection(DataSet<I1> ds1, DataSet<I2> ds2, int[] firstFieldIndexes, int[] secondFieldIndexes, CrossOperatorBase.CrossHint hint) {
            boolean isTuple;
            boolean firstInput;
            boolean isSecondTuple;
            boolean isFirstTuple;
            this.ds1 = ds1;
            this.ds2 = ds2;
            this.hint = hint;
            if (ds1.getType() instanceof TupleTypeInfo) {
                this.numFieldsDs1 = ((TupleTypeInfo)ds1.getType()).getArity();
                isFirstTuple = true;
            } else {
                this.numFieldsDs1 = 1;
                isFirstTuple = false;
            }
            if (ds2.getType() instanceof TupleTypeInfo) {
                this.numFieldsDs2 = ((TupleTypeInfo)ds2.getType()).getArity();
                isSecondTuple = true;
            } else {
                this.numFieldsDs2 = 1;
                isSecondTuple = false;
            }
            if (firstFieldIndexes != null && secondFieldIndexes == null) {
                firstInput = true;
                isTuple = isFirstTuple;
                this.fieldIndexes = firstFieldIndexes;
                if (this.fieldIndexes.length == 0) {
                    isTuple = false;
                }
            } else if (firstFieldIndexes == null && secondFieldIndexes != null) {
                firstInput = false;
                isTuple = isSecondTuple;
                this.fieldIndexes = secondFieldIndexes;
                if (this.fieldIndexes.length == 0) {
                    isTuple = false;
                }
            } else {
                if (firstFieldIndexes == null && secondFieldIndexes == null) {
                    throw new IllegalArgumentException("You must provide at least one field index array.");
                }
                throw new IllegalArgumentException("You must provide at most one field index array.");
            }
            if (!isTuple && this.fieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectFirst() (or projectSecond()) without arguments to include it.");
            }
            if (this.fieldIndexes.length > 22) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields.");
            }
            if (isTuple) {
                this.isFieldInFirst = new boolean[this.fieldIndexes.length];
                int maxFieldIndex = firstInput ? this.numFieldsDs1 : this.numFieldsDs2;
                for (int i = 0; i < this.fieldIndexes.length; ++i) {
                    Preconditions.checkElementIndex(this.fieldIndexes[i], maxFieldIndex);
                    this.isFieldInFirst[i] = firstInput;
                }
            } else {
                this.isFieldInFirst = new boolean[]{firstInput};
                this.fieldIndexes = new int[]{-1};
            }
        }

        protected CrossProjection<I1, I2> projectFirst(int ... firstFieldIndexes) {
            boolean isFirstTuple = this.ds1.getType() instanceof TupleTypeInfo && firstFieldIndexes.length > 0;
            if (!isFirstTuple && firstFieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectFirst() without arguments to include it.");
            }
            if (firstFieldIndexes.length > 22 - this.fieldIndexes.length) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields in total.");
            }
            int offset = this.fieldIndexes.length;
            if (isFirstTuple) {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + firstFieldIndexes.length);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + firstFieldIndexes.length);
                int maxFieldIndex = this.numFieldsDs1;
                for (int i = 0; i < firstFieldIndexes.length; ++i) {
                    Preconditions.checkElementIndex(firstFieldIndexes[i], maxFieldIndex);
                    this.isFieldInFirst[offset + i] = true;
                    this.fieldIndexes[offset + i] = firstFieldIndexes[i];
                }
            } else {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + 1);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + 1);
                this.isFieldInFirst[offset] = true;
                this.fieldIndexes[offset] = -1;
            }
            return this;
        }

        protected CrossProjection<I1, I2> projectSecond(int ... secondFieldIndexes) {
            boolean isSecondTuple = this.ds2.getType() instanceof TupleTypeInfo && secondFieldIndexes.length > 0;
            if (!isSecondTuple && secondFieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectSecond() without arguments to include it.");
            }
            if (secondFieldIndexes.length > 22 - this.fieldIndexes.length) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields in total.");
            }
            int offset = this.fieldIndexes.length;
            if (isSecondTuple) {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + secondFieldIndexes.length);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + secondFieldIndexes.length);
                int maxFieldIndex = this.numFieldsDs2;
                for (int i = 0; i < secondFieldIndexes.length; ++i) {
                    Preconditions.checkElementIndex(secondFieldIndexes[i], maxFieldIndex);
                    this.isFieldInFirst[offset + i] = false;
                    this.fieldIndexes[offset + i] = secondFieldIndexes[i];
                }
            } else {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + 1);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + 1);
                this.isFieldInFirst[offset] = false;
                this.fieldIndexes[offset] = -1;
            }
            return this;
        }

        public <OUT extends Tuple> ProjectCross<I1, I2, OUT> projectTupleX() {
            ProjectCross<I1, I2, Tuple> projectionCross = null;
            switch (this.fieldIndexes.length) {
                case 1: {
                    projectionCross = this.projectTuple1();
                    break;
                }
                case 2: {
                    projectionCross = this.projectTuple2();
                    break;
                }
                case 3: {
                    projectionCross = this.projectTuple3();
                    break;
                }
                case 4: {
                    projectionCross = this.projectTuple4();
                    break;
                }
                case 5: {
                    projectionCross = this.projectTuple5();
                    break;
                }
                case 6: {
                    projectionCross = this.projectTuple6();
                    break;
                }
                case 7: {
                    projectionCross = this.projectTuple7();
                    break;
                }
                case 8: {
                    projectionCross = this.projectTuple8();
                    break;
                }
                case 9: {
                    projectionCross = this.projectTuple9();
                    break;
                }
                case 10: {
                    projectionCross = this.projectTuple10();
                    break;
                }
                case 11: {
                    projectionCross = this.projectTuple11();
                    break;
                }
                case 12: {
                    projectionCross = this.projectTuple12();
                    break;
                }
                case 13: {
                    projectionCross = this.projectTuple13();
                    break;
                }
                case 14: {
                    projectionCross = this.projectTuple14();
                    break;
                }
                case 15: {
                    projectionCross = this.projectTuple15();
                    break;
                }
                case 16: {
                    projectionCross = this.projectTuple16();
                    break;
                }
                case 17: {
                    projectionCross = this.projectTuple17();
                    break;
                }
                case 18: {
                    projectionCross = this.projectTuple18();
                    break;
                }
                case 19: {
                    projectionCross = this.projectTuple19();
                    break;
                }
                case 20: {
                    projectionCross = this.projectTuple20();
                    break;
                }
                case 21: {
                    projectionCross = this.projectTuple21();
                    break;
                }
                case 22: {
                    projectionCross = this.projectTuple22();
                    break;
                }
                case 23: {
                    projectionCross = this.projectTuple23();
                    break;
                }
                case 24: {
                    projectionCross = this.projectTuple24();
                    break;
                }
                case 25: {
                    projectionCross = this.projectTuple25();
                    break;
                }
                default: {
                    throw new IllegalStateException("Excessive arity in tuple.");
                }
            }
            return projectionCross;
        }

        public <T0> ProjectCross<I1, I2, Tuple1<T0>> projectTuple1() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1> ProjectCross<I1, I2, Tuple2<T0, T1>> projectTuple2() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2> ProjectCross<I1, I2, Tuple3<T0, T1, T2>> projectTuple3() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3> ProjectCross<I1, I2, Tuple4<T0, T1, T2, T3>> projectTuple4() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4> ProjectCross<I1, I2, Tuple5<T0, T1, T2, T3, T4>> projectTuple5() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5> ProjectCross<I1, I2, Tuple6<T0, T1, T2, T3, T4, T5>> projectTuple6() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6> ProjectCross<I1, I2, Tuple7<T0, T1, T2, T3, T4, T5, T6>> projectTuple7() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7> ProjectCross<I1, I2, Tuple8<T0, T1, T2, T3, T4, T5, T6, T7>> projectTuple8() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8> ProjectCross<I1, I2, Tuple9<T0, T1, T2, T3, T4, T5, T6, T7, T8>> projectTuple9() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> ProjectCross<I1, I2, Tuple10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>> projectTuple10() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> ProjectCross<I1, I2, Tuple11<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> projectTuple11() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> ProjectCross<I1, I2, Tuple12<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> projectTuple12() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> ProjectCross<I1, I2, Tuple13<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> projectTuple13() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> ProjectCross<I1, I2, Tuple14<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> projectTuple14() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> ProjectCross<I1, I2, Tuple15<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> projectTuple15() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> ProjectCross<I1, I2, Tuple16<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> projectTuple16() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> ProjectCross<I1, I2, Tuple17<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> projectTuple17() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> ProjectCross<I1, I2, Tuple18<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> projectTuple18() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> ProjectCross<I1, I2, Tuple19<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> projectTuple19() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> ProjectCross<I1, I2, Tuple20<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> projectTuple20() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> ProjectCross<I1, I2, Tuple21<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> projectTuple21() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> ProjectCross<I1, I2, Tuple22<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> projectTuple22() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> ProjectCross<I1, I2, Tuple23<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> projectTuple23() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> ProjectCross<I1, I2, Tuple24<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>> projectTuple24() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> ProjectCross<I1, I2, Tuple25<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>> projectTuple25() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectCross(this.ds1, this.ds2, this.fieldIndexes, this.isFieldInFirst, tType, this, this.hint);
        }

        private TypeInformation<?>[] extractFieldTypes(int[] fields) {
            TypeInformation[] fieldTypes = new TypeInformation[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                Object typeInfo = this.isFieldInFirst[i] ? (fields[i] >= 0 ? ((TupleTypeInfo)this.ds1.getType()).getTypeAt(fields[i]) : this.ds1.getType()) : (fields[i] >= 0 ? ((TupleTypeInfo)this.ds2.getType()).getTypeAt(fields[i]) : this.ds2.getType());
                fieldTypes[i] = typeInfo;
            }
            return fieldTypes;
        }
    }

    public static final class ProjectCrossFunction<T1, T2, R extends Tuple>
    implements CrossFunction<T1, T2, R> {
        private static final long serialVersionUID = 1L;
        private final int[] fields;
        private final boolean[] isFromFirst;
        private final R outTuple;

        private ProjectCrossFunction(int[] fields, boolean[] isFromFirst, R outTupleInstance) {
            if (fields.length != isFromFirst.length) {
                throw new IllegalArgumentException("Fields and isFromFirst arrays must have same length!");
            }
            this.fields = fields;
            this.isFromFirst = isFromFirst;
            this.outTuple = outTupleInstance;
        }

        public R cross(T1 in1, T2 in2) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.isFromFirst[i]) {
                    if (this.fields[i] >= 0) {
                        ((Tuple)this.outTuple).setField(((Tuple)in1).getField(this.fields[i]), i);
                        continue;
                    }
                    ((Tuple)this.outTuple).setField(in1, i);
                    continue;
                }
                if (this.fields[i] >= 0) {
                    ((Tuple)this.outTuple).setField(((Tuple)in2).getField(this.fields[i]), i);
                    continue;
                }
                ((Tuple)this.outTuple).setField(in2, i);
            }
            return this.outTuple;
        }

        protected int[] getFields() {
            return this.fields;
        }

        protected boolean[] getIsFromFirst() {
            return this.isFromFirst;
        }

        /* synthetic */ ProjectCrossFunction(int[] x0, boolean[] x1, Tuple x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static final class ProjectCross<I1, I2, OUT extends Tuple>
    extends CrossOperator<I1, I2, OUT> {
        private CrossProjection<I1, I2> crossProjection;

        protected ProjectCross(DataSet<I1> input1, DataSet<I2> input2, int[] fields, boolean[] isFromFirst, TupleTypeInfo<OUT> returnType, CrossOperatorBase.CrossHint hint) {
            super(input1, input2, new ProjectCrossFunction(fields, isFromFirst, (Tuple)returnType.createSerializer(input1.getExecutionEnvironment().getConfig()).createInstance(), null), returnType, hint, "unknown");
            this.crossProjection = null;
        }

        protected ProjectCross(DataSet<I1> input1, DataSet<I2> input2, int[] fields, boolean[] isFromFirst, TupleTypeInfo<OUT> returnType, CrossProjection<I1, I2> crossProjection, CrossOperatorBase.CrossHint hint) {
            super(input1, input2, new ProjectCrossFunction(fields, isFromFirst, (Tuple)returnType.createSerializer(input1.getExecutionEnvironment().getConfig()).createInstance(), null), returnType, hint, "unknown");
            this.crossProjection = crossProjection;
        }

        @Override
        protected ProjectCrossFunction<I1, I2, OUT> getFunction() {
            return (ProjectCrossFunction)super.getFunction();
        }

        public <OUT extends Tuple> ProjectCross<I1, I2, OUT> projectFirst(int ... firstFieldIndexes) {
            this.crossProjection = this.crossProjection.projectFirst(firstFieldIndexes);
            return this.crossProjection.projectTupleX();
        }

        public <OUT extends Tuple> ProjectCross<I1, I2, OUT> projectSecond(int ... secondFieldIndexes) {
            this.crossProjection = this.crossProjection.projectSecond(secondFieldIndexes);
            return this.crossProjection.projectTupleX();
        }

        @Deprecated
        public <OUT extends Tuple> CrossOperator<I1, I2, OUT> types(Class<?> ... types) {
            TupleTypeInfo typeInfo = (TupleTypeInfo)this.getResultType();
            if (types.length != typeInfo.getArity()) {
                throw new InvalidProgramException("Provided types do not match projection.");
            }
            for (int i = 0; i < types.length; ++i) {
                Class<?> typeClass = types[i];
                if (typeClass.equals(typeInfo.getTypeAt(i).getTypeClass())) continue;
                throw new InvalidProgramException("Provided type " + typeClass.getSimpleName() + " at position " + i + " does not match projection");
            }
            return this;
        }

        @Override
        public CrossOperator<I1, I2, OUT> withForwardedFieldsFirst(String ... forwardedFieldsFirst) {
            throw new InvalidProgramException("The semantic properties (forwarded fields) are automatically calculated.");
        }

        @Override
        public CrossOperator<I1, I2, OUT> withForwardedFieldsSecond(String ... forwardedFieldsSecond) {
            throw new InvalidProgramException("The semantic properties (forwarded fields) are automatically calculated.");
        }

        @Override
        protected DualInputSemanticProperties extractSemanticAnnotationsFromUdf(Class<?> udfClass) {
            return SemanticPropUtil.createProjectionPropertiesDual(this.getFunction().getFields(), this.getFunction().getIsFromFirst(), this.getInput1Type(), this.getInput2Type());
        }
    }

    public static final class DefaultCross<I1, I2>
    extends CrossOperator<I1, I2, Tuple2<I1, I2>> {
        private final DataSet<I1> input1;
        private final DataSet<I2> input2;

        public DefaultCross(DataSet<I1> input1, DataSet<I2> input2, CrossOperatorBase.CrossHint hint, String defaultName) {
            super(input1, input2, new DefaultCrossFunction(), new TupleTypeInfo(input1.getType(), input2.getType()), hint, defaultName);
            if (input1 == null || input2 == null) {
                throw new NullPointerException();
            }
            this.input1 = input1;
            this.input2 = input2;
        }

        public <R> CrossOperator<I1, I2, R> with(CrossFunction<I1, I2, R> function) {
            if (function == null) {
                throw new NullPointerException("Cross function must not be null.");
            }
            TypeInformation<R> returnType = TypeExtractor.getCrossReturnTypes(function, this.input1.getType(), this.input2.getType(), ((CrossOperator)this).getDefaultName(), true);
            return new CrossOperator<I1, I2, R>(this.input1, this.input2, this.clean(function), returnType, this.getCrossHint(), Utils.getCallLocationName());
        }

        public <OUT extends Tuple> ProjectCross<I1, I2, OUT> projectFirst(int ... firstFieldIndexes) {
            return new CrossProjection(this.getInput1(), this.getInput2(), firstFieldIndexes, null, this.getCrossHint()).projectTupleX();
        }

        public <OUT extends Tuple> ProjectCross<I1, I2, OUT> projectSecond(int ... secondFieldIndexes) {
            return new CrossProjection(this.getInput1(), this.getInput2(), null, secondFieldIndexes, this.getCrossHint()).projectTupleX();
        }
    }
}

