/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sca;

import java.lang.reflect.Field;
import org.apache.flink.api.java.sca.CodeAnalyzerException;
import org.apache.flink.api.java.sca.ModifiedASMFrame;
import org.apache.flink.api.java.sca.NestedMethodAnalyzer;
import org.apache.flink.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.apache.flink.shaded.org.objectweb.asm.tree.InsnList;
import org.apache.flink.shaded.org.objectweb.asm.tree.JumpInsnNode;
import org.apache.flink.shaded.org.objectweb.asm.tree.analysis.Analyzer;
import org.apache.flink.shaded.org.objectweb.asm.tree.analysis.Frame;
import org.apache.flink.shaded.org.objectweb.asm.tree.analysis.Interpreter;

public class ModifiedASMAnalyzer
extends Analyzer {
    private NestedMethodAnalyzer interpreter;
    private int jumpModification = -1;
    private static final int NO_MOD = -1;
    private static final int IFEQ_MOD = 0;
    private static final int IFNE_MOD = 1;
    private int eventInsn;
    private int jumpModificationState = -1;
    private static final int DO_NOTHING = -1;
    private static final int PRE_STATE = 0;
    private static final int MOD_STATE = 1;
    private static final int WAIT_FOR_INSN_STATE = 2;

    public ModifiedASMAnalyzer(Interpreter interpreter) {
        super(interpreter);
        this.interpreter = (NestedMethodAnalyzer)interpreter;
    }

    @Override
    protected Frame newFrame(int nLocals, int nStack) {
        return new ModifiedASMFrame(nLocals, nStack);
    }

    @Override
    protected Frame newFrame(Frame src) {
        return new ModifiedASMFrame(src);
    }

    public void requestIFEQLoopModification() {
        if (this.jumpModificationState != -1) {
            throw new CodeAnalyzerException("Unable to do jump modifications (unsupported nested jumping).");
        }
        this.jumpModification = 0;
        this.jumpModificationState = 0;
    }

    public void requestIFNELoopModification() {
        if (this.jumpModificationState != -1) {
            throw new CodeAnalyzerException("Unable to do jump modifications (unsupported nested jumping).");
        }
        this.jumpModification = 1;
        this.jumpModificationState = 0;
    }

    @Override
    protected void newControlFlowEdge(int insn, int successor) {
        try {
            if (this.jumpModificationState == 0) {
                this.jumpModificationState = 1;
            } else if (this.jumpModificationState == 1) {
                if (this.jumpModification == 0) {
                    int top = this.accessField(Analyzer.class, "top").getInt(this);
                    int[] queue = (int[])this.accessField(Analyzer.class, "queue").get(this);
                    int tmp = queue[top - 2];
                    queue[top - 2] = queue[top - 1];
                    queue[top - 1] = tmp;
                    this.eventInsn = queue[top - 2] - 1;
                    InsnList insns = (InsnList)this.accessField(Analyzer.class, "insns").get(this);
                    this.jumpModificationState = insns.get(this.eventInsn) instanceof JumpInsnNode ? 2 : -1;
                } else if (this.jumpModification == 1) {
                    Frame[] frames = (Frame[])this.accessField(Analyzer.class, "frames").get(this);
                    Field indexField = this.accessField(AbstractInsnNode.class, "index");
                    InsnList insns = (InsnList)this.accessField(Analyzer.class, "insns").get(this);
                    AbstractInsnNode gotoInsnn = insns.get(successor - 1);
                    if (gotoInsnn instanceof JumpInsnNode) {
                        int idx;
                        this.jumpModificationState = 2;
                        for (int i = idx = indexField.getInt(this.accessField(JumpInsnNode.class, "label").get(gotoInsnn)); i <= insn; ++i) {
                            ((ModifiedASMFrame)frames[i]).mergePriority = true;
                        }
                        this.eventInsn = idx - 2;
                    } else {
                        this.jumpModificationState = -1;
                    }
                }
            } else if (this.jumpModificationState == 2 && insn == this.eventInsn) {
                this.jumpModificationState = -1;
                Frame[] frames = (Frame[])this.accessField(Analyzer.class, "frames").get(this);
                if (this.jumpModification == 0) {
                    this.interpreter.rightMergePriority = true;
                    Field top = this.accessField(Frame.class, "top");
                    top.setInt(frames[this.eventInsn], top.getInt(frames[this.eventInsn + 1]));
                    frames[this.eventInsn + 1].merge(frames[this.eventInsn], this.interpreter);
                } else if (this.jumpModification == 1) {
                    ((ModifiedASMFrame)frames[this.eventInsn + 1]).mergePriority = true;
                }
            }
        }
        catch (Exception e) {
            throw new CodeAnalyzerException("Unable to do jump modifications.", e);
        }
    }

    private Field accessField(Class<?> clazz, String name) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            f.setAccessible(true);
            return f;
        }
        return null;
    }
}

