/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.IOException;
import org.apache.flink.api.java.record.io.ExternalProcessInputFormat;
import org.apache.flink.api.java.record.io.ExternalProcessInputSplit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.types.Record;

public abstract class ExternalProcessFixedLengthInputFormat<T extends ExternalProcessInputSplit>
extends ExternalProcessInputFormat<T> {
    private static final long serialVersionUID = 1L;
    public static final String RECORDLENGTH_PARAMETER_KEY = "pact.input.recordLength";
    private static final int DEFAULT_TARGET_READ_BUFFER_SIZE = 0x100000;
    private byte[] readBuffer;
    private int readBufferReadPos;
    private int readBufferFillPos;
    private int readBufferRemainSpace;
    private int targetReadBufferSize = 0x100000;
    protected int recordLength;
    private boolean noMoreStreamInput;
    private boolean noMoreRecordBuffers;

    public abstract boolean readBytes(Record var1, byte[] var2, int var3);

    @Override
    public void configure(Configuration parameters) {
        super.configure(parameters);
        this.recordLength = parameters.getInteger(RECORDLENGTH_PARAMETER_KEY, 0);
        if (this.recordLength < 1) {
            throw new IllegalArgumentException("The record length parameter must be set and larger than 0.");
        }
    }

    public void setTargetReadBufferSize(int targetReadBufferSize) {
        this.targetReadBufferSize = targetReadBufferSize;
    }

    @Override
    public void open(GenericInputSplit split) throws IOException {
        super.open(split);
        this.readBuffer = this.recordLength > this.targetReadBufferSize ? new byte[this.recordLength] : (this.targetReadBufferSize % this.recordLength == 0 ? new byte[this.targetReadBufferSize] : new byte[this.recordLength - this.targetReadBufferSize % this.recordLength + this.targetReadBufferSize]);
        this.readBufferReadPos = 0;
        this.readBufferFillPos = 0;
        this.readBufferRemainSpace = this.readBuffer.length;
        this.noMoreStreamInput = false;
        this.noMoreRecordBuffers = false;
    }

    public boolean reachedEnd() throws IOException {
        return this.noMoreRecordBuffers;
    }

    public Record nextRecord(Record reuse) throws IOException {
        if (this.readBufferFillPos - this.readBufferReadPos < this.recordLength && !this.fillReadBuffer()) {
            return null;
        }
        this.readBufferReadPos += this.recordLength;
        return this.readBytes(reuse, this.readBuffer, this.readBufferReadPos - this.recordLength) ? reuse : null;
    }

    private boolean fillReadBuffer() throws IOException {
        if (this.noMoreStreamInput) {
            if (this.readBufferReadPos == this.readBufferFillPos) {
                this.noMoreRecordBuffers = true;
                return false;
            }
            throw new RuntimeException("External process produced incomplete record");
        }
        if (this.readBufferReadPos == this.readBuffer.length && this.readBufferRemainSpace == 0) {
            this.readBufferFillPos = 0;
            this.readBufferRemainSpace = this.readBuffer.length;
            this.readBufferReadPos = 0;
        }
        while (this.readBufferFillPos - this.readBufferReadPos < this.recordLength) {
            int readCnt = this.extProcOutStream.read(this.readBuffer, this.readBufferFillPos, this.readBufferRemainSpace);
            if (readCnt == -1) {
                this.noMoreStreamInput = true;
                return false;
            }
            this.readBufferFillPos += readCnt;
            this.readBufferRemainSpace -= readCnt;
        }
        return true;
    }
}

