/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.FunctionAnnotation;

public class SemanticPropUtil {
    private static final String REGEX_LIST = "(\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))";
    private static final String REGEX_FORWARD = "(\\s*(\\d+)\\s*->((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\*)))";
    private static final String REGEX_LIST_OR_FORWARD = "((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\s*(\\d+)\\s*->((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\*))))";
    private static final String REGEX_ANNOTATION = "(\\s*(((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\s*(\\d+)\\s*->((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\*))))\\s*;\\s*)*(((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\s*(\\d+)\\s*->((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\*))))\\s*))";
    private static final Pattern PATTERN_FORWARD = Pattern.compile("(\\s*(\\d+)\\s*->((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\*)))");
    private static final Pattern PATTERN_ANNOTATION = Pattern.compile("(\\s*(((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\s*(\\d+)\\s*->((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\*))))\\s*;\\s*)*(((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\s*(\\d+)\\s*->((\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))|(\\*))))\\s*))");
    private static final Pattern PATTERN_LIST = Pattern.compile("(\\s*(\\d+\\s*,\\s*)*(\\d+\\s*))");
    private static final Pattern PATTERN_DIGIT = Pattern.compile("\\d+");

    public static SingleInputSemanticProperties createProjectionPropertiesSingle(int[] fields) {
        SingleInputSemanticProperties ssp = new SingleInputSemanticProperties();
        for (int i = 0; i < fields.length; ++i) {
            ssp.addForwardedField(fields[i], i);
        }
        return ssp;
    }

    public static DualInputSemanticProperties createProjectionPropertiesDual(int[] fields, boolean[] isFromFirst) {
        DualInputSemanticProperties dsp = new DualInputSemanticProperties();
        for (int i = 0; i < fields.length; ++i) {
            if (isFromFirst[i]) {
                dsp.addForwardedField1(fields[i], i);
                continue;
            }
            dsp.addForwardedField2(fields[i], i);
        }
        return dsp;
    }

    public static SingleInputSemanticProperties getSemanticPropsSingle(Set<Annotation> set, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (set == null) {
            return null;
        }
        Iterator<Annotation> it = set.iterator();
        SingleInputSemanticProperties result = null;
        if (!inType.isTupleType() || !outType.isTupleType()) {
            return null;
        }
        while (it.hasNext()) {
            Annotation ann;
            if (result == null) {
                result = new SingleInputSemanticProperties();
            }
            if ((ann = it.next()) instanceof FunctionAnnotation.ConstantFields) {
                FunctionAnnotation.ConstantFields cf = (FunctionAnnotation.ConstantFields)ann;
                SemanticPropUtil.parseConstantFields(cf.value(), result, inType, outType);
                continue;
            }
            if (ann instanceof FunctionAnnotation.ConstantFieldsExcept) {
                FunctionAnnotation.ConstantFieldsExcept cfe = (FunctionAnnotation.ConstantFieldsExcept)ann;
                SemanticPropUtil.parseConstantFieldsExcept(cfe.value(), result, inType, outType);
                continue;
            }
            if (!(ann instanceof FunctionAnnotation.ReadFields)) continue;
            FunctionAnnotation.ReadFields rf = (FunctionAnnotation.ReadFields)ann;
            SemanticPropUtil.parseReadFields(rf.value(), result, inType, outType);
        }
        return result;
    }

    private static void parseConstantFields(String[] cf, SingleInputSemanticProperties sm, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (cf == null) {
            return;
        }
        for (String s : cf) {
            if (s == null) continue;
            SemanticPropUtil.readConstantSet((SemanticProperties)sm, s, inType, outType, 0);
        }
    }

    private static void readConstantSet(SemanticProperties sp, String s, TypeInformation<?> inType, TypeInformation<?> outType, int input) {
        FieldSet fs;
        if (s.equals("*")) {
            if (sp instanceof SingleInputSemanticProperties) {
                for (int i = 0; i < inType.getArity() && i < outType.getArity(); ++i) {
                    ((SingleInputSemanticProperties)sp).addForwardedField(i, i);
                }
            } else if (sp instanceof DualInputSemanticProperties) {
                for (int i = 0; i < inType.getArity() && i < outType.getArity(); ++i) {
                    if (input == 0) {
                        ((DualInputSemanticProperties)sp).addForwardedField1(i, i);
                        continue;
                    }
                    if (input != 1) continue;
                    ((DualInputSemanticProperties)sp).addForwardedField2(i, i);
                }
            }
            return;
        }
        Matcher matcher = PATTERN_ANNOTATION.matcher(s);
        if (!matcher.matches()) {
            throw new InvalidProgramException("Unrecognized annotation string format.");
        }
        Matcher forwardMatcher = PATTERN_FORWARD.matcher(s);
        while (forwardMatcher.find()) {
            int sourceField = Integer.valueOf(forwardMatcher.group(2));
            if (!SemanticPropUtil.isValidField(inType, sourceField)) {
                throw new IndexOutOfBoundsException("Annotation: Field " + sourceField + " not available in the input tuple.");
            }
            if (forwardMatcher.group(7) != null) {
                if (sp instanceof SingleInputSemanticProperties) {
                    for (int i = 0; i < outType.getArity(); ++i) {
                        ((SingleInputSemanticProperties)sp).addForwardedField(sourceField, i);
                    }
                    continue;
                }
                if (!(sp instanceof DualInputSemanticProperties)) continue;
                for (int i = 0; i < outType.getArity(); ++i) {
                    if (input == 0) {
                        ((DualInputSemanticProperties)sp).addForwardedField1(sourceField, i);
                        continue;
                    }
                    if (input != 1) continue;
                    ((DualInputSemanticProperties)sp).addForwardedField2(sourceField, i);
                }
                continue;
            }
            String found = forwardMatcher.group(4);
            fs = SemanticPropUtil.readFieldSetFromString(found, inType, outType);
            if (sp instanceof SingleInputSemanticProperties) {
                ((SingleInputSemanticProperties)sp).addForwardedField(sourceField, fs);
                continue;
            }
            if (!(sp instanceof DualInputSemanticProperties)) continue;
            if (input == 0) {
                ((DualInputSemanticProperties)sp).addForwardedField1(sourceField, fs);
                continue;
            }
            if (input != 1) continue;
            ((DualInputSemanticProperties)sp).addForwardedField2(sourceField, fs);
        }
        s = forwardMatcher.replaceAll("");
        Matcher listMatcher = PATTERN_LIST.matcher(s);
        while (listMatcher.find()) {
            String list = listMatcher.group();
            fs = SemanticPropUtil.readFieldSetFromString(list, inType, outType);
            Iterator iterator = fs.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (sp instanceof SingleInputSemanticProperties) {
                    ((SingleInputSemanticProperties)sp).addForwardedField(i, i);
                    continue;
                }
                if (!(sp instanceof DualInputSemanticProperties)) continue;
                if (input == 0) {
                    ((DualInputSemanticProperties)sp).addForwardedField1(i, i);
                    continue;
                }
                if (input != 1) continue;
                ((DualInputSemanticProperties)sp).addForwardedField2(i, i);
            }
        }
    }

    private static void parseConstantFieldsFirst(String[] cff, DualInputSemanticProperties dm, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (cff == null) {
            return;
        }
        for (String s : cff) {
            if (s == null) continue;
            SemanticPropUtil.readConstantSet((SemanticProperties)dm, s, inType, outType, 0);
        }
    }

    private static void parseConstantFieldsSecond(String[] cfs, DualInputSemanticProperties dm, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (cfs == null) {
            return;
        }
        for (String s : cfs) {
            if (s == null) continue;
            SemanticPropUtil.readConstantSet((SemanticProperties)dm, s, inType, outType, 1);
        }
    }

    private static void parseConstantFieldsFirstExcept(String[] cffe, DualInputSemanticProperties dm, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (cffe == null) {
            return;
        }
        for (String str : cffe) {
            if (str == null) continue;
            FieldSet fs = SemanticPropUtil.readFieldSetFromString(str, inType, outType);
            for (int i = 0; i < outType.getArity(); ++i) {
                if (fs.contains(Integer.valueOf(i))) continue;
                dm.addForwardedField1(i, i);
            }
        }
    }

    private static void parseConstantFieldsSecondExcept(String[] cfse, DualInputSemanticProperties dm, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (cfse == null) {
            return;
        }
        for (String str : cfse) {
            if (str == null) continue;
            FieldSet fs = SemanticPropUtil.readFieldSetFromString(str, inType, outType);
            for (int i = 0; i < outType.getArity(); ++i) {
                if (fs.contains(Integer.valueOf(i))) continue;
                dm.addForwardedField2(i, i);
            }
        }
    }

    private static void parseReadFieldsFirst(String[] rf, DualInputSemanticProperties dm, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (rf == null) {
            return;
        }
        for (String str : rf) {
            if (str == null) continue;
            FieldSet fs = SemanticPropUtil.readFieldSetFromString(str, inType, outType);
            dm.addReadFields1(fs);
        }
    }

    private static void parseReadFieldsSecond(String[] rf, DualInputSemanticProperties dm, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (rf == null) {
            return;
        }
        for (String str : rf) {
            if (str == null) continue;
            FieldSet fs = SemanticPropUtil.readFieldSetFromString(str, inType, outType);
            dm.addReadFields2(fs);
        }
    }

    private static boolean isValidField(TypeInformation<?> type, int field) {
        return field >= 0 && field < type.getArity();
    }

    private static void parseConstantFieldsExcept(String[] cfe, SingleInputSemanticProperties sm, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (cfe == null) {
            return;
        }
        for (String str : cfe) {
            if (str == null) continue;
            FieldSet fs = SemanticPropUtil.readFieldSetFromString(str, inType, outType);
            for (int i = 0; i < outType.getArity(); ++i) {
                if (fs.contains(Integer.valueOf(i))) continue;
                sm.addForwardedField(i, i);
            }
        }
    }

    private static FieldSet readFieldSetFromString(String s, TypeInformation<?> inType, TypeInformation<?> outType) {
        Matcher matcher = PATTERN_LIST.matcher(s);
        if (!matcher.matches()) {
            throw new InvalidProgramException("Unrecognized annotation string format.");
        }
        matcher = PATTERN_DIGIT.matcher(s);
        FieldSet fs = FieldSet.EMPTY_SET;
        while (matcher.find()) {
            int field = Integer.valueOf(matcher.group());
            if (!SemanticPropUtil.isValidField(outType, field)) {
                throw new IndexOutOfBoundsException("Annotation: Field " + field + " not available in the output tuple.");
            }
            if (!SemanticPropUtil.isValidField(inType, field)) {
                throw new IndexOutOfBoundsException("Annotation: Field " + field + " not available in the input tuple.");
            }
            fs = fs.addField(Integer.valueOf(field));
        }
        return fs;
    }

    private static void parseReadFields(String[] rf, SingleInputSemanticProperties sm, TypeInformation<?> inType, TypeInformation<?> outType) {
        if (rf == null) {
            return;
        }
        for (String str : rf) {
            if (str == null) continue;
            FieldSet fs = SemanticPropUtil.readFieldSetFromString(str, inType, outType);
            sm.addReadFields(fs);
        }
    }

    public static SingleInputSemanticProperties getSemanticPropsSingleFromString(String[] constantSet, String[] constantSetExcept, String[] readSet, TypeInformation<?> inType, TypeInformation<?> outType) {
        SingleInputSemanticProperties result = new SingleInputSemanticProperties();
        SemanticPropUtil.parseConstantFields(constantSet, result, inType, outType);
        SemanticPropUtil.parseConstantFieldsExcept(constantSetExcept, result, inType, outType);
        SemanticPropUtil.parseReadFields(readSet, result, inType, outType);
        return result;
    }

    public static void getSemanticPropsDualFromString(DualInputSemanticProperties target, String[] constantSetFirst, String[] constantSetSecond, String[] constantSetFirstExcept, String[] constantSetSecondExcept, String[] readFieldsFirst, String[] readFieldsSecond, TypeInformation<?> inType1, TypeInformation<?> inType2, TypeInformation<?> outType) {
        SemanticPropUtil.parseConstantFieldsFirst(constantSetFirst, target, inType1, outType);
        SemanticPropUtil.parseConstantFieldsSecond(constantSetSecond, target, inType2, outType);
        SemanticPropUtil.parseConstantFieldsFirstExcept(constantSetFirstExcept, target, inType1, outType);
        SemanticPropUtil.parseConstantFieldsSecondExcept(constantSetSecondExcept, target, inType2, outType);
        SemanticPropUtil.parseReadFieldsFirst(readFieldsFirst, target, inType1, outType);
        SemanticPropUtil.parseReadFieldsSecond(readFieldsSecond, target, inType2, outType);
    }

    public static DualInputSemanticProperties getSemanticPropsDual(Set<Annotation> set, TypeInformation<?> inType1, TypeInformation<?> inType2, TypeInformation<?> outType) {
        if (set == null) {
            return null;
        }
        Iterator<Annotation> it = set.iterator();
        DualInputSemanticProperties result = null;
        if (!(inType1.isTupleType() && inType2.isTupleType() && outType.isTupleType())) {
            return null;
        }
        while (it.hasNext()) {
            Annotation ann;
            if (result == null) {
                result = new DualInputSemanticProperties();
            }
            if ((ann = it.next()) instanceof FunctionAnnotation.ConstantFieldsFirst) {
                FunctionAnnotation.ConstantFieldsFirst cff = (FunctionAnnotation.ConstantFieldsFirst)ann;
                SemanticPropUtil.parseConstantFieldsFirst(cff.value(), result, inType1, outType);
                continue;
            }
            if (ann instanceof FunctionAnnotation.ConstantFieldsSecond) {
                FunctionAnnotation.ConstantFieldsSecond cfs = (FunctionAnnotation.ConstantFieldsSecond)ann;
                SemanticPropUtil.parseConstantFieldsSecond(cfs.value(), result, inType2, outType);
                continue;
            }
            if (ann instanceof FunctionAnnotation.ConstantFieldsFirstExcept) {
                FunctionAnnotation.ConstantFieldsFirstExcept cffe = (FunctionAnnotation.ConstantFieldsFirstExcept)ann;
                SemanticPropUtil.parseConstantFieldsFirstExcept(cffe.value(), result, inType1, outType);
                continue;
            }
            if (ann instanceof FunctionAnnotation.ConstantFieldsSecondExcept) {
                FunctionAnnotation.ConstantFieldsSecondExcept cfse = (FunctionAnnotation.ConstantFieldsSecondExcept)ann;
                SemanticPropUtil.parseConstantFieldsSecondExcept(cfse.value(), result, inType2, outType);
                continue;
            }
            if (ann instanceof FunctionAnnotation.ReadFieldsFirst) {
                FunctionAnnotation.ReadFieldsFirst rff = (FunctionAnnotation.ReadFieldsFirst)ann;
                SemanticPropUtil.parseReadFieldsFirst(rff.value(), result, inType1, outType);
                continue;
            }
            if (!(ann instanceof FunctionAnnotation.ReadFieldsSecond)) continue;
            FunctionAnnotation.ReadFieldsSecond rfs = (FunctionAnnotation.ReadFieldsSecond)ann;
            SemanticPropUtil.parseReadFieldsSecond(rfs.value(), result, inType2, outType);
        }
        return result;
    }
}

