/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.operators.base.PartitionOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.functions.FirstReducer;
import org.apache.flink.api.java.functions.FormattingMapper;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.SelectByMaxFunction;
import org.apache.flink.api.java.functions.SelectByMinFunction;
import org.apache.flink.api.java.io.CsvOutputFormat;
import org.apache.flink.api.java.io.PrintingOutputFormat;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.CrossOperator;
import org.apache.flink.api.java.operators.CustomUnaryOperation;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.IterativeDataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.api.java.operators.PartitionOperator;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.apache.flink.api.java.operators.UnsortedGrouping;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public abstract class DataSet<T> {
    private final ExecutionEnvironment context;
    private final TypeInformation<T> type;

    protected DataSet(ExecutionEnvironment context, TypeInformation<T> type) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.context = context;
        this.type = type;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.context;
    }

    public TypeInformation<T> getType() {
        return this.type;
    }

    public <F> F clean(F f) {
        if (this.getExecutionEnvironment().getConfig().isClosureCleanerEnabled()) {
            ClosureCleaner.clean(f, true);
        }
        ClosureCleaner.ensureSerializable(f);
        return f;
    }

    public <R> MapOperator<T, R> map(MapFunction<T, R> mapper) {
        if (mapper == null) {
            throw new NullPointerException("Map function must not be null.");
        }
        TypeInformation<R> resultType = TypeExtractor.getMapReturnTypes(mapper, this.getType());
        return new MapOperator<T, R>(this, resultType, this.clean(mapper), Utils.getCallLocationName());
    }

    public <R> MapPartitionOperator<T, R> mapPartition(MapPartitionFunction<T, R> mapPartition) {
        if (mapPartition == null) {
            throw new NullPointerException("MapPartition function must not be null.");
        }
        TypeInformation<R> resultType = TypeExtractor.getMapPartitionReturnTypes(mapPartition, this.getType());
        return new MapPartitionOperator<T, R>(this, resultType, this.clean(mapPartition), Utils.getCallLocationName());
    }

    public <R> FlatMapOperator<T, R> flatMap(FlatMapFunction<T, R> flatMapper) {
        if (flatMapper == null) {
            throw new NullPointerException("FlatMap function must not be null.");
        }
        TypeInformation<R> resultType = TypeExtractor.getFlatMapReturnTypes(flatMapper, this.getType());
        return new FlatMapOperator<T, R>(this, resultType, this.clean(flatMapper), Utils.getCallLocationName());
    }

    public FilterOperator<T> filter(FilterFunction<T> filter) {
        if (filter == null) {
            throw new NullPointerException("Filter function must not be null.");
        }
        return new FilterOperator<T>(this, this.clean(filter), Utils.getCallLocationName());
    }

    public <OUT extends Tuple> ProjectOperator<?, OUT> project(int ... fieldIndexes) {
        return new ProjectOperator.Projection(this, fieldIndexes).projectTupleX();
    }

    public AggregateOperator<T> aggregate(Aggregations agg, int field) {
        return new AggregateOperator(this, agg, field, Utils.getCallLocationName());
    }

    public AggregateOperator<T> sum(int field) {
        return this.aggregate(Aggregations.SUM, field);
    }

    public AggregateOperator<T> max(int field) {
        return this.aggregate(Aggregations.MAX, field);
    }

    public AggregateOperator<T> min(int field) {
        return this.aggregate(Aggregations.MIN, field);
    }

    public ReduceOperator<T> reduce(ReduceFunction<T> reducer) {
        if (reducer == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        return new ReduceOperator<T>(this, this.clean(reducer), Utils.getCallLocationName());
    }

    public <R> GroupReduceOperator<T, R> reduceGroup(GroupReduceFunction<T, R> reducer) {
        if (reducer == null) {
            throw new NullPointerException("GroupReduce function must not be null.");
        }
        TypeInformation<R> resultType = TypeExtractor.getGroupReduceReturnTypes(reducer, this.getType());
        return new GroupReduceOperator<T, R>(this, resultType, this.clean(reducer), Utils.getCallLocationName());
    }

    public ReduceOperator<T> minBy(int ... fields) {
        if (!this.type.isTupleType()) {
            throw new InvalidProgramException("DataSet#minBy(int...) only works on Tuple types.");
        }
        return new ReduceOperator(this, new SelectByMinFunction((TupleTypeInfo)this.type, fields), Utils.getCallLocationName());
    }

    public ReduceOperator<T> maxBy(int ... fields) {
        if (!this.type.isTupleType()) {
            throw new InvalidProgramException("DataSet#maxBy(int...) only works on Tuple types.");
        }
        return new ReduceOperator(this, new SelectByMaxFunction((TupleTypeInfo)this.type, fields), Utils.getCallLocationName());
    }

    public GroupReduceOperator<T, T> first(int n) {
        if (n < 1) {
            throw new InvalidProgramException("Parameter n of first(n) must be at least 1.");
        }
        return this.reduceGroup(new FirstReducer(n));
    }

    public <K> DistinctOperator<T> distinct(KeySelector<T, K> keyExtractor) {
        TypeInformation<K> keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, this.type);
        return new DistinctOperator(this, new Keys.SelectorFunctionKeys<T, K>(keyExtractor, this.getType(), keyType), Utils.getCallLocationName());
    }

    public DistinctOperator<T> distinct(int ... fields) {
        return new DistinctOperator<T>(this, new Keys.ExpressionKeys<T>(fields, this.getType(), true), Utils.getCallLocationName());
    }

    public DistinctOperator<T> distinct(String ... fields) {
        return new DistinctOperator<T>(this, new Keys.ExpressionKeys<T>(fields, this.getType()), Utils.getCallLocationName());
    }

    public DistinctOperator<T> distinct() {
        return new DistinctOperator(this, null, Utils.getCallLocationName());
    }

    public <K> UnsortedGrouping<T> groupBy(KeySelector<T, K> keyExtractor) {
        TypeInformation<K> keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, this.type);
        return new UnsortedGrouping(this, new Keys.SelectorFunctionKeys<T, K>(this.clean(keyExtractor), this.getType(), keyType));
    }

    public UnsortedGrouping<T> groupBy(int ... fields) {
        return new UnsortedGrouping<T>(this, new Keys.ExpressionKeys<T>(fields, this.getType(), false));
    }

    public UnsortedGrouping<T> groupBy(String ... fields) {
        return new UnsortedGrouping<T>(this, new Keys.ExpressionKeys<T>(fields, this.getType()));
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> join(DataSet<R> other) {
        return new JoinOperator.JoinOperatorSets(this, other);
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> join(DataSet<R> other, JoinOperatorBase.JoinHint strategy) {
        return new JoinOperator.JoinOperatorSets(this, other, strategy);
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> joinWithTiny(DataSet<R> other) {
        return new JoinOperator.JoinOperatorSets(this, other, JoinOperatorBase.JoinHint.BROADCAST_HASH_SECOND);
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> joinWithHuge(DataSet<R> other) {
        return new JoinOperator.JoinOperatorSets(this, other, JoinOperatorBase.JoinHint.BROADCAST_HASH_FIRST);
    }

    public <R> CoGroupOperator.CoGroupOperatorSets<T, R> coGroup(DataSet<R> other) {
        return new CoGroupOperator.CoGroupOperatorSets(this, other);
    }

    public <R> CrossOperator.DefaultCross<T, R> cross(DataSet<R> other) {
        return new CrossOperator.DefaultCross(this, other, Utils.getCallLocationName());
    }

    public <R> CrossOperator.DefaultCross<T, R> crossWithTiny(DataSet<R> other) {
        return new CrossOperator.DefaultCross(this, other, Utils.getCallLocationName());
    }

    public <R> CrossOperator.DefaultCross<T, R> crossWithHuge(DataSet<R> other) {
        return new CrossOperator.DefaultCross(this, other, Utils.getCallLocationName());
    }

    public IterativeDataSet<T> iterate(int maxIterations) {
        return new IterativeDataSet<T>(this.getExecutionEnvironment(), this.getType(), this, maxIterations);
    }

    public <R> DeltaIteration<T, R> iterateDelta(DataSet<R> workset, int maxIterations, int ... keyPositions) {
        Preconditions.checkNotNull(workset);
        Preconditions.checkNotNull((Object)keyPositions);
        Keys.ExpressionKeys<T> keys = new Keys.ExpressionKeys<T>(keyPositions, this.getType(), false);
        return new DeltaIteration<T, R>(this.getExecutionEnvironment(), this.getType(), this, workset, keys, maxIterations);
    }

    public <X> DataSet<X> runOperation(CustomUnaryOperation<T, X> operation) {
        Validate.notNull(operation, (String)"The custom operator must not be null.", (Object[])new Object[0]);
        operation.setInput(this);
        return operation.createResult();
    }

    public UnionOperator<T> union(DataSet<T> other) {
        return new UnionOperator<T>(this, other, Utils.getCallLocationName());
    }

    public PartitionOperator<T> partitionByHash(int ... fields) {
        return new PartitionOperator<T>(this, PartitionOperatorBase.PartitionMethod.HASH, new Keys.ExpressionKeys<T>(fields, this.getType(), false), Utils.getCallLocationName());
    }

    public PartitionOperator<T> partitionByHash(String ... fields) {
        return new PartitionOperator<T>(this, PartitionOperatorBase.PartitionMethod.HASH, new Keys.ExpressionKeys<T>(fields, this.getType()), Utils.getCallLocationName());
    }

    public <K extends Comparable<K>> PartitionOperator<T> partitionByHash(KeySelector<T, K> keyExtractor) {
        TypeInformation<K> keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, this.type);
        return new PartitionOperator(this, PartitionOperatorBase.PartitionMethod.HASH, new Keys.SelectorFunctionKeys<T, K>(this.clean(keyExtractor), this.getType(), keyType), Utils.getCallLocationName());
    }

    public <K> PartitionOperator<T> partitionCustom(Partitioner<K> partitioner, int field) {
        return new PartitionOperator<T>(this, new Keys.ExpressionKeys<T>(new int[]{field}, this.getType(), false), this.clean(partitioner), Utils.getCallLocationName());
    }

    public <K> PartitionOperator<T> partitionCustom(Partitioner<K> partitioner, String field) {
        return new PartitionOperator<T>(this, new Keys.ExpressionKeys<T>(new String[]{field}, this.getType()), this.clean(partitioner), Utils.getCallLocationName());
    }

    public <K extends Comparable<K>> PartitionOperator<T> partitionCustom(Partitioner<K> partitioner, KeySelector<T, K> keyExtractor) {
        TypeInformation<K> keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, this.type);
        return new PartitionOperator(this, new Keys.SelectorFunctionKeys<T, K>(keyExtractor, this.getType(), keyType), this.clean(partitioner), Utils.getCallLocationName());
    }

    public PartitionOperator<T> rebalance() {
        return new PartitionOperator(this, PartitionOperatorBase.PartitionMethod.REBALANCE, Utils.getCallLocationName());
    }

    public DataSink<T> writeAsText(String filePath) {
        return this.output((OutputFormat<T>)new TextOutputFormat(new Path(filePath)));
    }

    public DataSink<T> writeAsText(String filePath, FileSystem.WriteMode writeMode) {
        TextOutputFormat tof = new TextOutputFormat(new Path(filePath));
        tof.setWriteMode(writeMode);
        return this.output((OutputFormat<T>)tof);
    }

    public DataSink<String> writeAsFormattedText(String filePath, TextOutputFormat.TextFormatter<T> formatter) {
        return this.map(new FormattingMapper<T>(formatter)).writeAsText(filePath);
    }

    public DataSink<String> writeAsFormattedText(String filePath, FileSystem.WriteMode writeMode, TextOutputFormat.TextFormatter<T> formatter) {
        return this.map(new FormattingMapper<T>(this.clean(formatter))).writeAsText(filePath, writeMode);
    }

    public DataSink<T> writeAsCsv(String filePath) {
        return this.writeAsCsv(filePath, "\n", CsvOutputFormat.DEFAULT_FIELD_DELIMITER);
    }

    public DataSink<T> writeAsCsv(String filePath, FileSystem.WriteMode writeMode) {
        return this.internalWriteAsCsv(new Path(filePath), "\n", CsvOutputFormat.DEFAULT_FIELD_DELIMITER, writeMode);
    }

    public DataSink<T> writeAsCsv(String filePath, String rowDelimiter, String fieldDelimiter) {
        return this.internalWriteAsCsv(new Path(filePath), rowDelimiter, fieldDelimiter, null);
    }

    public DataSink<T> writeAsCsv(String filePath, String rowDelimiter, String fieldDelimiter, FileSystem.WriteMode writeMode) {
        return this.internalWriteAsCsv(new Path(filePath), rowDelimiter, fieldDelimiter, writeMode);
    }

    private <X extends Tuple> DataSink<T> internalWriteAsCsv(Path filePath, String rowDelimiter, String fieldDelimiter, FileSystem.WriteMode wm) {
        Validate.isTrue((boolean)this.type.isTupleType(), (String)"The writeAsCsv() method can only be used on data sets of tuples.", (Object[])new Object[0]);
        CsvOutputFormat of = new CsvOutputFormat(filePath, rowDelimiter, fieldDelimiter);
        if (wm != null) {
            of.setWriteMode(wm);
        }
        return this.output((OutputFormat<T>)of);
    }

    public DataSink<T> print() {
        return this.output(new PrintingOutputFormat(false));
    }

    public DataSink<T> printToErr() {
        return this.output(new PrintingOutputFormat(true));
    }

    public DataSink<T> write(FileOutputFormat<T> outputFormat, String filePath) {
        Validate.notNull((Object)filePath, (String)"File path must not be null.", (Object[])new Object[0]);
        Validate.notNull(outputFormat, (String)"Output format must not be null.", (Object[])new Object[0]);
        outputFormat.setOutputFilePath(new Path(filePath));
        return this.output((OutputFormat<T>)outputFormat);
    }

    public DataSink<T> write(FileOutputFormat<T> outputFormat, String filePath, FileSystem.WriteMode writeMode) {
        Validate.notNull((Object)filePath, (String)"File path must not be null.", (Object[])new Object[0]);
        Validate.notNull((Object)writeMode, (String)"Write mode must not be null.", (Object[])new Object[0]);
        Validate.notNull(outputFormat, (String)"Output format must not be null.", (Object[])new Object[0]);
        outputFormat.setOutputFilePath(new Path(filePath));
        outputFormat.setWriteMode(writeMode);
        return this.output((OutputFormat<T>)outputFormat);
    }

    public DataSink<T> output(OutputFormat<T> outputFormat) {
        Validate.notNull(outputFormat);
        if (outputFormat instanceof InputTypeConfigurable) {
            ((InputTypeConfigurable)outputFormat).setInputType(this.type);
        }
        DataSink<T> sink = new DataSink<T>(this, outputFormat, this.type);
        this.context.registerDataSink(sink);
        return sink;
    }

    protected static void checkSameExecutionContext(DataSet<?> set1, DataSet<?> set2) {
        if (set1.context != set2.context) {
            throw new IllegalArgumentException("The two inputs have different execution contexts.");
        }
    }
}

