/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.util.InstantiationUtil;

public class CopyableValueSerializer<T extends CopyableValue<T>>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> valueClass;
    private transient T instance;

    public CopyableValueSerializer(Class<T> valueClass) {
        this.valueClass = valueClass;
    }

    public boolean isImmutableType() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public T createInstance() {
        return (T)((CopyableValue)InstantiationUtil.instantiate(this.valueClass));
    }

    public T copy(T from) {
        return this.copy(from, this.createInstance());
    }

    public T copy(T from, T reuse) {
        from.copyTo(reuse);
        return reuse;
    }

    public int getLength() {
        this.ensureInstanceInstantiated();
        return this.instance.getBinaryLength();
    }

    public void serialize(T value, DataOutputView target) throws IOException {
        value.write(target);
    }

    public T deserialize(DataInputView source) throws IOException {
        return this.deserialize(this.createInstance(), source);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.ensureInstanceInstantiated();
        this.instance.copy(source, target);
    }

    private void ensureInstanceInstantiated() {
        if (this.instance == null) {
            this.instance = this.createInstance();
        }
    }

    public int hashCode() {
        return this.valueClass.hashCode() + 9231;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == CopyableValueSerializer.class) {
            CopyableValueSerializer other = (CopyableValueSerializer)((Object)obj);
            return this.valueClass == other.valueClass;
        }
        return false;
    }
}

