/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.functions.FirstReducer;
import org.apache.flink.api.java.functions.SelectByMaxFunction;
import org.apache.flink.api.java.functions.SelectByMinFunction;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.operators.SortedGrouping;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;

public class UnsortedGrouping<T>
extends Grouping<T> {
    public UnsortedGrouping(DataSet<T> set, Keys<T> keys) {
        super(set, keys);
    }

    public AggregateOperator<T> aggregate(Aggregations agg, int field) {
        return new AggregateOperator(this, agg, field);
    }

    public AggregateOperator<T> sum(int field) {
        return this.aggregate(Aggregations.SUM, field);
    }

    public AggregateOperator<T> max(int field) {
        return this.aggregate(Aggregations.MAX, field);
    }

    public AggregateOperator<T> min(int field) {
        return this.aggregate(Aggregations.MIN, field);
    }

    public ReduceOperator<T> reduce(ReduceFunction<T> reducer) {
        if (reducer == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        return new ReduceOperator<T>(this, reducer);
    }

    public <R> GroupReduceOperator<T, R> reduceGroup(GroupReduceFunction<T, R> reducer) {
        if (reducer == null) {
            throw new NullPointerException("GroupReduce function must not be null.");
        }
        TypeInformation<R> resultType = TypeExtractor.getGroupReduceReturnTypes(reducer, this.getDataSet().getType());
        return new GroupReduceOperator<T, R>(this, resultType, reducer);
    }

    public GroupReduceOperator<T, T> first(int n) {
        if (n < 1) {
            throw new InvalidProgramException("Parameter n of first(n) must be at least 1.");
        }
        return this.reduceGroup(new FirstReducer(n));
    }

    public ReduceOperator<T> minBy(int ... fields) {
        if (!this.dataSet.getType().isTupleType()) {
            throw new InvalidProgramException("Method minBy(int) only works on tuples.");
        }
        return new ReduceOperator(this, new SelectByMinFunction((TupleTypeInfo)this.dataSet.getType(), fields));
    }

    public ReduceOperator<T> maxBy(int ... fields) {
        if (!this.dataSet.getType().isTupleType()) {
            throw new InvalidProgramException("Method maxBy(int) only works on tuples.");
        }
        return new ReduceOperator(this, new SelectByMaxFunction((TupleTypeInfo)this.dataSet.getType(), fields));
    }

    public SortedGrouping<T> sortGroup(int field, Order order) {
        return new SortedGrouping(this.dataSet, this.keys, field, order);
    }

    public SortedGrouping<T> sortGroup(String field, Order order) {
        return new SortedGrouping(this.dataSet, this.keys, field, order);
    }
}

