/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.FilterOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.translation.PlanFilterOperator;

public class FilterOperator<T>
extends SingleInputUdfOperator<T, T, FilterOperator<T>> {
    protected final FilterFunction<T> function;

    public FilterOperator(DataSet<T> input, FilterFunction<T> function) {
        super(input, input.getType());
        this.function = function;
        this.extractSemanticAnnotationsFromUdf(function.getClass());
    }

    protected FilterOperatorBase<T, FlatMapFunction<T, T>> translateToDataFlow(Operator<T> input) {
        String name = this.getName() != null ? this.getName() : this.function.getClass().getName();
        PlanFilterOperator<T> po = new PlanFilterOperator<T>(this.function, name, this.getInputType());
        po.setInput(input);
        if (this.getParallelism() > 0) {
            po.setDegreeOfParallelism(this.getParallelism());
        } else {
            po.setDegreeOfParallelism(input.getDegreeOfParallelism());
        }
        return po;
    }
}

