/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.operators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.RecordOperator;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.functions.JoinFunction;
import org.apache.flink.api.java.record.operators.DeltaIteration;
import org.apache.flink.api.java.record.operators.OperatorInfoHelper;
import org.apache.flink.types.Key;
import org.apache.flink.types.Record;

public class JoinOperator
extends JoinOperatorBase<Record, Record, Record, JoinFunction>
implements RecordOperator {
    private final Class<? extends Key<?>>[] keyTypes;

    public static Builder builder(JoinFunction udf, Class<? extends Key<?>> keyClass, int keyColumn1, int keyColumn2) {
        return new Builder((UserCodeWrapper<JoinFunction>)new UserCodeObjectWrapper((Object)udf), keyClass, keyColumn1, keyColumn2);
    }

    public static Builder builder(Class<? extends JoinFunction> udf, Class<? extends Key<?>> keyClass, int keyColumn1, int keyColumn2) {
        return new Builder((UserCodeWrapper<JoinFunction>)new UserCodeClassWrapper(udf), keyClass, keyColumn1, keyColumn2);
    }

    protected JoinOperator(Builder builder) {
        super(builder.udf, OperatorInfoHelper.binary(), builder.getKeyColumnsArray1(), builder.getKeyColumnsArray2(), builder.name);
        int[] positions;
        this.keyTypes = builder.getKeyClassesArray();
        if (builder.inputs1 != null && !builder.inputs1.isEmpty()) {
            this.setFirstInput(Operator.createUnionCascade((List)builder.inputs1));
        }
        if (builder.inputs2 != null && !builder.inputs2.isEmpty()) {
            this.setSecondInput(Operator.createUnionCascade((List)builder.inputs2));
        }
        if (this.input1 instanceof DeltaIteration.SolutionSetPlaceHolder) {
            positions = this.getKeyColumns(0);
            ((DeltaIteration.SolutionSetPlaceHolder)this.input1).checkJoinKeyFields(positions);
        }
        if (this.input2 instanceof DeltaIteration.SolutionSetPlaceHolder) {
            positions = this.getKeyColumns(1);
            ((DeltaIteration.SolutionSetPlaceHolder)this.input2).checkJoinKeyFields(positions);
        }
        this.setBroadcastVariables(builder.broadcastInputs);
        this.setSemanticProperties(FunctionAnnotation.readDualConstantAnnotations(builder.udf));
    }

    public Class<? extends Key<?>>[] getKeyClasses() {
        return this.keyTypes;
    }

    public static class Builder {
        private final UserCodeWrapper<JoinFunction> udf;
        private final List<Class<? extends Key<?>>> keyClasses;
        private final List<Integer> keyColumns1;
        private final List<Integer> keyColumns2;
        private List<Operator<Record>> inputs1;
        private List<Operator<Record>> inputs2;
        private Map<String, Operator<Record>> broadcastInputs;
        private String name;

        protected Builder(UserCodeWrapper<JoinFunction> udf, Class<? extends Key<?>> keyClass, int keyColumn1, int keyColumn2) {
            this.udf = udf;
            this.keyClasses = new ArrayList();
            this.keyClasses.add(keyClass);
            this.keyColumns1 = new ArrayList<Integer>();
            this.keyColumns1.add(keyColumn1);
            this.keyColumns2 = new ArrayList<Integer>();
            this.keyColumns2.add(keyColumn2);
            this.inputs1 = new ArrayList<Operator<Record>>();
            this.inputs2 = new ArrayList<Operator<Record>>();
            this.broadcastInputs = new HashMap<String, Operator<Record>>();
        }

        protected Builder(UserCodeWrapper<JoinFunction> udf) {
            this.udf = udf;
            this.keyClasses = new ArrayList();
            this.keyColumns1 = new ArrayList<Integer>();
            this.keyColumns2 = new ArrayList<Integer>();
            this.inputs1 = new ArrayList<Operator<Record>>();
            this.inputs2 = new ArrayList<Operator<Record>>();
            this.broadcastInputs = new HashMap<String, Operator<Record>>();
        }

        private int[] getKeyColumnsArray1() {
            int[] result = new int[this.keyColumns1.size()];
            for (int i = 0; i < this.keyColumns1.size(); ++i) {
                result[i] = this.keyColumns1.get(i);
            }
            return result;
        }

        private int[] getKeyColumnsArray2() {
            int[] result = new int[this.keyColumns2.size()];
            for (int i = 0; i < this.keyColumns2.size(); ++i) {
                result[i] = this.keyColumns2.get(i);
            }
            return result;
        }

        private Class<? extends Key<?>>[] getKeyClassesArray() {
            return this.keyClasses.toArray(new Class[this.keyClasses.size()]);
        }

        public Builder keyField(Class<? extends Key<?>> keyClass, int keyColumn1, int keyColumn2) {
            this.keyClasses.add(keyClass);
            this.keyColumns1.add(keyColumn1);
            this.keyColumns2.add(keyColumn2);
            return this;
        }

        public Builder input1(Operator<Record> input) {
            Validate.notNull(input, (String)"The input must not be null", (Object[])new Object[0]);
            this.inputs1.clear();
            this.inputs1.add(input);
            return this;
        }

        public Builder input2(Operator<Record> input) {
            Validate.notNull(input, (String)"The input must not be null", (Object[])new Object[0]);
            this.inputs2.clear();
            this.inputs2.add(input);
            return this;
        }

        public Builder input1(Operator<Record> ... inputs) {
            this.inputs1.clear();
            for (Operator<Record> c : inputs) {
                this.inputs1.add(c);
            }
            return this;
        }

        public Builder input2(Operator<Record> ... inputs) {
            this.inputs2.clear();
            for (Operator<Record> c : inputs) {
                this.inputs2.add(c);
            }
            return this;
        }

        public Builder inputs1(List<Operator<Record>> inputs) {
            this.inputs1 = inputs;
            return this;
        }

        public Builder inputs2(List<Operator<Record>> inputs) {
            this.inputs2 = inputs;
            return this;
        }

        public Builder setBroadcastVariable(String name, Operator<Record> input) {
            this.broadcastInputs.put(name, input);
            return this;
        }

        public Builder setBroadcastVariables(Map<String, Operator<Record>> inputs) {
            this.broadcastInputs.clear();
            this.broadcastInputs.putAll(inputs);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public JoinOperator build() {
            if (this.keyClasses.size() <= 0) {
                throw new IllegalStateException("At least one key attribute has to be set.");
            }
            if (this.name == null) {
                this.name = this.udf.getUserCodeClass().getName();
            }
            return new JoinOperator(this);
        }
    }
}

