/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.functions.FlatCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.RichGroupReduceFunction;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.SortedGrouping;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingReduceGroupOperator;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.types.TypeInformation;

public class GroupReduceOperator<IN, OUT>
extends SingleInputUdfOperator<IN, OUT, GroupReduceOperator<IN, OUT>> {
    private final GroupReduceFunction<IN, OUT> function;
    private final Grouping<IN> grouper;
    private boolean combinable;

    public GroupReduceOperator(DataSet<IN> input, GroupReduceFunction<IN, OUT> function) {
        super(input, TypeExtractor.getGroupReduceReturnTypes(function, input.getType()));
        this.function = function;
        this.grouper = null;
        this.checkCombinability();
    }

    public GroupReduceOperator(Grouping<IN> input, GroupReduceFunction<IN, OUT> function) {
        super(input != null ? input.getDataSet() : null, TypeExtractor.getGroupReduceReturnTypes(function, input.getDataSet().getType()));
        this.function = function;
        this.grouper = input;
        this.checkCombinability();
        this.extractSemanticAnnotationsFromUdf(function.getClass());
    }

    private void checkCombinability() {
        if (this.function instanceof FlatCombineFunction && this.function.getClass().getAnnotation(RichGroupReduceFunction.Combinable.class) != null) {
            this.combinable = true;
        }
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public void setCombinable(boolean combinable) {
        if (combinable && !(this.function instanceof FlatCombineFunction)) {
            throw new IllegalArgumentException("The function does not implement the combine interface.");
        }
        this.combinable = combinable;
    }

    @Override
    protected GroupReduceOperatorBase<?, OUT, ?> translateToDataFlow(Operator<IN> input) {
        String name;
        String string = name = this.getName() != null ? this.getName() : this.function.getClass().getName();
        if (this.grouper == null) {
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(this.function, operatorInfo, new int[0], name);
            po.setCombinable(this.combinable);
            po.setInput(input);
            po.setDegreeOfParallelism(1);
            return po;
        }
        if (this.grouper.getKeys() instanceof Keys.SelectorFunctionKeys) {
            Keys.SelectorFunctionKeys selectorKeys = (Keys.SelectorFunctionKeys)this.grouper.getKeys();
            PlanUnwrappingReduceGroupOperator po = GroupReduceOperator.translateSelectorFunctionReducer(selectorKeys, this.function, this.getInputType(), this.getResultType(), name, input, this.isCombinable());
            po.setDegreeOfParallelism(this.getParallelism());
            return po;
        }
        if (this.grouper.getKeys() instanceof Keys.FieldPositionKeys) {
            int[] logicalKeyPositions = this.grouper.getKeys().computeLogicalKeyPositions();
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(this.function, operatorInfo, logicalKeyPositions, name);
            po.setCombinable(this.combinable);
            po.setInput(input);
            po.setDegreeOfParallelism(this.getParallelism());
            if (this.grouper instanceof SortedGrouping) {
                SortedGrouping sortedGrouper = (SortedGrouping)this.grouper;
                int[] sortKeyPositions = sortedGrouper.getGroupSortKeyPositions();
                Order[] sortOrders = sortedGrouper.getGroupSortOrders();
                Ordering o = new Ordering();
                for (int i = 0; i < sortKeyPositions.length; ++i) {
                    o.appendOrdering(Integer.valueOf(sortKeyPositions[i]), null, sortOrders[i]);
                }
                po.setGroupOrder(o);
            }
            return po;
        }
        if (this.grouper.getKeys() instanceof Keys.ExpressionKeys) {
            int[] logicalKeyPositions = this.grouper.getKeys().computeLogicalKeyPositions();
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(this.function, operatorInfo, logicalKeyPositions, name);
            po.setCombinable(this.combinable);
            po.setInput(input);
            po.setDegreeOfParallelism(this.getParallelism());
            return po;
        }
        throw new UnsupportedOperationException("Unrecognized key type.");
    }

    private static <IN, OUT, K> PlanUnwrappingReduceGroupOperator<IN, OUT, K> translateSelectorFunctionReducer(Keys.SelectorFunctionKeys<IN, ?> rawKeys, GroupReduceFunction<IN, OUT> function, TypeInformation<IN> inputType, TypeInformation<OUT> outputType, String name, Operator<IN> input, boolean combinable) {
        Keys.SelectorFunctionKeys<IN, ?> keys = rawKeys;
        TupleTypeInfo typeInfoWithKey = new TupleTypeInfo(keys.getKeyType(), inputType);
        KeyExtractingMapper extractor = new KeyExtractingMapper(keys.getKeyExtractor());
        PlanUnwrappingReduceGroupOperator reducer = new PlanUnwrappingReduceGroupOperator(function, keys, name, outputType, typeInfoWithKey, combinable);
        MapOperatorBase mapper = new MapOperatorBase(extractor, new UnaryOperatorInformation(inputType, typeInfoWithKey), "Key Extractor");
        reducer.setInput((Operator)mapper);
        mapper.setInput(input);
        mapper.setDegreeOfParallelism(input.getDegreeOfParallelism());
        return reducer;
    }
}

