/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.GenericDataSinkBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.types.NothingTypeInfo;
import org.apache.flink.types.TypeInformation;

public class DataSink<T> {
    private final OutputFormat<T> format;
    private final TypeInformation<T> type;
    private final DataSet<T> data;
    private String name;
    private int dop = -1;

    public DataSink(DataSet<T> data, OutputFormat<T> format, TypeInformation<T> type) {
        if (format == null) {
            throw new IllegalArgumentException("The output format must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("The input type information must not be null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("The data set must not be null.");
        }
        this.format = format;
        this.data = data;
        this.type = type;
    }

    public OutputFormat<T> getFormat() {
        return this.format;
    }

    public TypeInformation<T> getType() {
        return this.type;
    }

    public DataSet<T> getDataSet() {
        return this.data;
    }

    public DataSink<T> name(String name) {
        this.name = name;
        return this;
    }

    protected GenericDataSinkBase<T> translateToDataFlow(Operator<T> input) {
        String name = this.name != null ? this.name : this.format.toString();
        GenericDataSinkBase sink = new GenericDataSinkBase(this.format, new UnaryOperatorInformation(this.type, (TypeInformation)new NothingTypeInfo()), name);
        sink.setInput(input);
        if (this.dop > 0) {
            sink.setDegreeOfParallelism(this.dop);
        } else {
            sink.setDegreeOfParallelism(input.getDegreeOfParallelism());
        }
        return sink;
    }

    public String toString() {
        return "DataSink '" + (this.name == null ? "<unnamed>" : this.name) + "' (" + this.format.toString() + ")";
    }

    public int getParallelism() {
        return this.dop;
    }

    public DataSink<T> setParallelism(int dop) {
        if (dop < 1) {
            throw new IllegalArgumentException("The parallelism of an operator must be at least 1.");
        }
        this.dop = dop;
        return this;
    }
}

