/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DeltaIteration;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.IterativeDataSet;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.UnsupportedLambdaExpressionException;
import org.apache.flink.api.java.io.CsvOutputFormat;
import org.apache.flink.api.java.io.PrintingOutputFormat;
import org.apache.flink.api.java.io.TextOutputFormat;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.CrossOperator;
import org.apache.flink.api.java.operators.CustomUnaryOperation;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.ProjectOperator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.apache.flink.api.java.operators.UnsortedGrouping;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.InputTypeConfigurable;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.TypeInformation;

public abstract class DataSet<T> {
    private final ExecutionEnvironment context;
    private final TypeInformation<T> type;

    protected DataSet(ExecutionEnvironment context, TypeInformation<T> type) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.context = context;
        this.type = type;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.context;
    }

    public TypeInformation<T> getType() {
        return this.type;
    }

    public <R> MapOperator<T, R> map(MapFunction<T, R> mapper) {
        if (mapper == null) {
            throw new NullPointerException("Map function must not be null.");
        }
        if (FunctionUtils.isLambdaFunction(mapper)) {
            throw new UnsupportedLambdaExpressionException();
        }
        return new MapOperator<T, R>(this, mapper);
    }

    public <R> FlatMapOperator<T, R> flatMap(FlatMapFunction<T, R> flatMapper) {
        if (flatMapper == null) {
            throw new NullPointerException("FlatMap function must not be null.");
        }
        if (FunctionUtils.isLambdaFunction(flatMapper)) {
            throw new UnsupportedLambdaExpressionException();
        }
        return new FlatMapOperator<T, R>(this, flatMapper);
    }

    public FilterOperator<T> filter(FilterFunction<T> filter) {
        if (filter == null) {
            throw new NullPointerException("Filter function must not be null.");
        }
        return new FilterOperator<T>(this, filter);
    }

    public ProjectOperator.Projection<T> project(int ... fieldIndexes) {
        return new ProjectOperator.Projection(this, fieldIndexes);
    }

    public AggregateOperator<T> aggregate(Aggregations agg, int field) {
        return new AggregateOperator(this, agg, field);
    }

    public AggregateOperator<T> sum(int field) {
        return this.aggregate(Aggregations.SUM, field);
    }

    public AggregateOperator<T> max(int field) {
        return this.aggregate(Aggregations.MAX, field);
    }

    public AggregateOperator<T> min(int field) {
        return this.aggregate(Aggregations.MIN, field);
    }

    public ReduceOperator<T> reduce(ReduceFunction<T> reducer) {
        if (reducer == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        return new ReduceOperator<T>(this, reducer);
    }

    public <R> GroupReduceOperator<T, R> reduceGroup(GroupReduceFunction<T, R> reducer) {
        if (reducer == null) {
            throw new NullPointerException("GroupReduce function must not be null.");
        }
        if (FunctionUtils.isLambdaFunction(reducer)) {
            throw new UnsupportedLambdaExpressionException();
        }
        return new GroupReduceOperator<T, R>(this, reducer);
    }

    public <K extends Comparable<K>> DistinctOperator<T> distinct(KeySelector<T, K> keyExtractor) {
        return new DistinctOperator(this, new Keys.SelectorFunctionKeys<T, K>(keyExtractor, this.getType()));
    }

    public DistinctOperator<T> distinct(int ... fields) {
        return new DistinctOperator<T>(this, new Keys.FieldPositionKeys<T>(fields, this.getType(), true));
    }

    public DistinctOperator<T> distinct() {
        return new DistinctOperator(this, null);
    }

    public <K extends Comparable<K>> UnsortedGrouping<T> groupBy(KeySelector<T, K> keyExtractor) {
        return new UnsortedGrouping(this, new Keys.SelectorFunctionKeys<T, K>(keyExtractor, this.getType()));
    }

    public UnsortedGrouping<T> groupBy(int ... fields) {
        return new UnsortedGrouping<T>(this, new Keys.FieldPositionKeys<T>(fields, this.getType(), false));
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> join(DataSet<R> other) {
        return new JoinOperator.JoinOperatorSets(this, other);
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> joinWithTiny(DataSet<R> other) {
        return new JoinOperator.JoinOperatorSets(this, other, JoinOperator.JoinHint.BROADCAST_HASH_SECOND);
    }

    public <R> JoinOperator.JoinOperatorSets<T, R> joinWithHuge(DataSet<R> other) {
        return new JoinOperator.JoinOperatorSets(this, other, JoinOperator.JoinHint.BROADCAST_HASH_FIRST);
    }

    public <R> CoGroupOperator.CoGroupOperatorSets<T, R> coGroup(DataSet<R> other) {
        return new CoGroupOperator.CoGroupOperatorSets(this, other);
    }

    public <R> CrossOperator.DefaultCross<T, R> cross(DataSet<R> other) {
        return new CrossOperator.DefaultCross(this, other);
    }

    public <R> CrossOperator.DefaultCross<T, R> crossWithTiny(DataSet<R> other) {
        return new CrossOperator.DefaultCross(this, other);
    }

    public <R> CrossOperator.DefaultCross<T, R> crossWithHuge(DataSet<R> other) {
        return new CrossOperator.DefaultCross(this, other);
    }

    public IterativeDataSet<T> iterate(int maxIterations) {
        return new IterativeDataSet<T>(this.getExecutionEnvironment(), this.getType(), this, maxIterations);
    }

    public <R> DeltaIteration<T, R> iterateDelta(DataSet<R> workset, int maxIterations, int ... keyPositions) {
        Keys.FieldPositionKeys<T> keys = new Keys.FieldPositionKeys<T>(keyPositions, this.getType(), false);
        return new DeltaIteration<T, R>(this.getExecutionEnvironment(), this.getType(), this, workset, keys, maxIterations);
    }

    public <X> DataSet<X> runOperation(CustomUnaryOperation<T, X> operation) {
        Validate.notNull(operation, (String)"The custom operator must not be null.", (Object[])new Object[0]);
        operation.setInput(this);
        return operation.createResult();
    }

    public UnionOperator<T> union(DataSet<T> other) {
        return new UnionOperator<T>(this, other);
    }

    public DataSink<T> writeAsText(String filePath) {
        return this.output((OutputFormat<T>)new TextOutputFormat(new Path(filePath)));
    }

    public DataSink<T> writeAsText(String filePath, FileSystem.WriteMode writeMode) {
        TextOutputFormat tof = new TextOutputFormat(new Path(filePath));
        tof.setWriteMode(writeMode);
        return this.output((OutputFormat<T>)tof);
    }

    public DataSink<T> writeAsCsv(String filePath) {
        return this.writeAsCsv(filePath, "\n", CsvOutputFormat.DEFAULT_FIELD_DELIMITER);
    }

    public DataSink<T> writeAsCsv(String filePath, String rowDelimiter, String fieldDelimiter) {
        return this.internalWriteAsCsv(new Path(filePath), rowDelimiter, fieldDelimiter, null);
    }

    public DataSink<T> writeAsCsv(String filePath, String rowDelimiter, String fieldDelimiter, FileSystem.WriteMode writeMode) {
        return this.internalWriteAsCsv(new Path(filePath), rowDelimiter, fieldDelimiter, writeMode);
    }

    private <X extends Tuple> DataSink<T> internalWriteAsCsv(Path filePath, String rowDelimiter, String fieldDelimiter, FileSystem.WriteMode wm) {
        Validate.isTrue((boolean)this.type.isTupleType(), (String)"The writeAsCsv() method can only be used on data sets of tuples.", (Object[])new Object[0]);
        CsvOutputFormat of = new CsvOutputFormat(filePath, rowDelimiter, fieldDelimiter);
        if (wm != null) {
            of.setWriteMode(wm);
        }
        return this.output((OutputFormat<T>)of);
    }

    public DataSink<T> print() {
        return this.output(new PrintingOutputFormat(false));
    }

    public DataSink<T> printToErr() {
        return this.output(new PrintingOutputFormat(true));
    }

    public DataSink<T> write(FileOutputFormat<T> outputFormat, String filePath) {
        Validate.notNull((Object)filePath, (String)"File path must not be null.", (Object[])new Object[0]);
        Validate.notNull(outputFormat, (String)"Output format must not be null.", (Object[])new Object[0]);
        outputFormat.setOutputFilePath(new Path(filePath));
        return this.output((OutputFormat<T>)outputFormat);
    }

    public DataSink<T> write(FileOutputFormat<T> outputFormat, String filePath, FileSystem.WriteMode writeMode) {
        Validate.notNull((Object)filePath, (String)"File path must not be null.", (Object[])new Object[0]);
        Validate.notNull((Object)writeMode, (String)"Write mode must not be null.", (Object[])new Object[0]);
        Validate.notNull(outputFormat, (String)"Output format must not be null.", (Object[])new Object[0]);
        outputFormat.setOutputFilePath(new Path(filePath));
        outputFormat.setWriteMode(writeMode);
        return this.output((OutputFormat<T>)outputFormat);
    }

    public DataSink<T> output(OutputFormat<T> outputFormat) {
        Validate.notNull(outputFormat);
        if (outputFormat instanceof InputTypeConfigurable) {
            ((InputTypeConfigurable)outputFormat).setInputType(this.type);
        }
        DataSink<T> sink = new DataSink<T>(this, outputFormat, this.type);
        this.context.registerDataSink(sink);
        return sink;
    }

    protected static void checkSameExecutionContext(DataSet<?> set1, DataSet<?> set2) {
        if (set1.context != set2.context) {
            throw new IllegalArgumentException("The two inputs have different execution contexts.");
        }
    }
}

