/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.util.InstantiationUtil;

public class GenericTypeComparator<T extends Comparable<T>>
extends TypeComparator<T> {
    private static final long serialVersionUID = 1L;
    private final boolean ascending;
    private final Class<T> type;
    private TypeSerializer<T> serializer;
    private transient T reference;
    private transient T tmpReference;
    private final TypeComparator[] comparators = new TypeComparator[]{this};

    public GenericTypeComparator(boolean ascending, TypeSerializer<T> serializer, Class<T> type) {
        this.ascending = ascending;
        this.serializer = serializer;
        this.type = type;
    }

    private GenericTypeComparator(GenericTypeComparator<T> toClone) {
        this.ascending = toClone.ascending;
        this.serializer = toClone.serializer.duplicate();
        this.type = toClone.type;
    }

    public int hash(T record) {
        return record.hashCode();
    }

    public void setReference(T toCompare) {
        this.reference = (Comparable)this.serializer.copy(toCompare);
    }

    public boolean equalToReference(T candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<T> referencedComparator) {
        T otherRef = ((GenericTypeComparator)referencedComparator).reference;
        int cmp = otherRef.compareTo(this.reference);
        return this.ascending ? cmp : -cmp;
    }

    public int compare(T first, T second) {
        int cmp = first.compareTo(second);
        return this.ascending ? cmp : -cmp;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        if (this.reference == null) {
            this.reference = (Comparable)this.serializer.createInstance();
        }
        if (this.tmpReference == null) {
            this.tmpReference = (Comparable)this.serializer.createInstance();
        }
        this.reference = (Comparable)this.serializer.deserialize(this.reference, firstSource);
        this.tmpReference = (Comparable)this.serializer.deserialize(this.tmpReference, secondSource);
        int cmp = this.reference.compareTo(this.tmpReference);
        return this.ascending ? cmp : -cmp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(this.type);
    }

    public int getNormalizeKeyLen() {
        if (this.reference == null) {
            this.reference = (Comparable)InstantiationUtil.instantiate(this.type);
        }
        NormalizableKey key = (NormalizableKey)this.reference;
        return key.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(T record, MemorySegment target, int offset, int numBytes) {
        NormalizableKey key = (NormalizableKey)record;
        key.copyNormalizedKey(target, offset, numBytes);
    }

    public boolean invertNormalizedKey() {
        return !this.ascending;
    }

    public TypeComparator<T> duplicate() {
        return new GenericTypeComparator<T>(this);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

