/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple0;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.Tuple0Serializer;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.primitives.Ints;

public final class TupleTypeInfo<T extends Tuple>
extends TupleTypeInfoBase<T> {
    private static final long serialVersionUID = 1L;
    protected final String[] fieldNames;

    public TupleTypeInfo(TypeInformation<?> ... types) {
        this(Tuple.getTupleClass(types.length), types);
    }

    public TupleTypeInfo(Class<T> tupleType, TypeInformation<?> ... types) {
        super(tupleType, types);
        Preconditions.checkArgument(types.length <= 25, "The tuple type exceeds the maximum supported arity.");
        this.fieldNames = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.fieldNames[i] = "f" + i;
        }
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public int getFieldIndex(String fieldName) {
        int fieldIndex = Integer.parseInt(fieldName.substring(1));
        if (fieldIndex >= this.getArity()) {
            return -1;
        }
        return fieldIndex;
    }

    public TupleSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        if (this.getTypeClass() == Tuple0.class) {
            return Tuple0Serializer.INSTANCE;
        }
        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
        for (int i = 0; i < this.types.length; ++i) {
            fieldSerializers[i] = this.types[i].createSerializer(executionConfig);
        }
        Class tupleClass = this.getTypeClass();
        return new TupleSerializer(tupleClass, fieldSerializers);
    }

    protected CompositeType.TypeComparatorBuilder<T> createTypeComparatorBuilder() {
        return new TupleTypeComparatorBuilder();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TupleTypeInfo) {
            TupleTypeInfo other = (TupleTypeInfo)((Object)obj);
            return other.canEqual((Object)this) && super.equals((Object)other) && Arrays.equals(this.fieldNames, other.fieldNames);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof TupleTypeInfo;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Arrays.hashCode(this.fieldNames);
    }

    @Override
    public String toString() {
        return "Java " + super.toString();
    }

    public static <X extends Tuple> TupleTypeInfo<X> getBasicTupleTypeInfo(Class<?> ... basicTypes) {
        if (basicTypes == null || basicTypes.length == 0) {
            throw new IllegalArgumentException();
        }
        TypeInformation[] infos = new TypeInformation[basicTypes.length];
        for (int i = 0; i < infos.length; ++i) {
            Class<?> type = basicTypes[i];
            if (type == null) {
                throw new IllegalArgumentException("Type at position " + i + " is null.");
            }
            BasicTypeInfo info = BasicTypeInfo.getInfoFor(type);
            if (info == null) {
                throw new IllegalArgumentException("Type at position " + i + " is not a basic type.");
            }
            infos[i] = info;
        }
        TupleTypeInfo tupleInfo = new TupleTypeInfo(infos);
        return tupleInfo;
    }

    public static <X extends Tuple> TupleTypeInfo<X> getBasicAndBasicValueTupleTypeInfo(Class<?> ... basicTypes) {
        if (basicTypes == null || basicTypes.length == 0) {
            throw new IllegalArgumentException();
        }
        TypeInformation[] infos = new TypeInformation[basicTypes.length];
        for (int i = 0; i < infos.length; ++i) {
            Class<?> type = basicTypes[i];
            if (type == null) {
                throw new IllegalArgumentException("Type at position " + i + " is null.");
            }
            TypeInformation<?> info = BasicTypeInfo.getInfoFor(type);
            if (info == null) {
                try {
                    info = ValueTypeInfo.getValueTypeInfo(type);
                    if (!((ValueTypeInfo)info).isBasicValueType()) {
                        throw new IllegalArgumentException("Type at position " + i + " is not a basic or value type.");
                    }
                }
                catch (ClassCastException | InvalidTypesException e) {
                    throw new IllegalArgumentException("Type at position " + i + " is not a basic or value type.", e);
                }
            }
            infos[i] = info;
        }
        return new TupleTypeInfo(infos);
    }

    private class TupleTypeComparatorBuilder
    implements CompositeType.TypeComparatorBuilder<T> {
        private final ArrayList<TypeComparator> fieldComparators = new ArrayList();
        private final ArrayList<Integer> logicalKeyFields = new ArrayList();

        private TupleTypeComparatorBuilder() {
        }

        public void initializeTypeComparatorBuilder(int size) {
            this.fieldComparators.ensureCapacity(size);
            this.logicalKeyFields.ensureCapacity(size);
        }

        public void addComparatorField(int fieldId, TypeComparator<?> comparator) {
            this.fieldComparators.add(comparator);
            this.logicalKeyFields.add(fieldId);
        }

        public TypeComparator<T> createTypeComparator(ExecutionConfig config) {
            Preconditions.checkState(this.fieldComparators.size() > 0, "No field comparators were defined for the TupleTypeComparatorBuilder.");
            Preconditions.checkState(this.logicalKeyFields.size() > 0, "No key fields were defined for the TupleTypeComparatorBuilder.");
            Preconditions.checkState(this.fieldComparators.size() == this.logicalKeyFields.size(), "The number of field comparators and key fields is not equal.");
            int maxKey = Collections.max(this.logicalKeyFields);
            Preconditions.checkState(maxKey >= 0, "The maximum key field must be greater or equal than 0.");
            TypeSerializer[] fieldSerializers = new TypeSerializer[maxKey + 1];
            for (int i = 0; i <= maxKey; ++i) {
                fieldSerializers[i] = TupleTypeInfo.this.types[i].createSerializer(config);
            }
            return new TupleComparator(Ints.toArray(this.logicalKeyFields), this.fieldComparators.toArray(new TypeComparator[this.fieldComparators.size()]), fieldSerializers);
        }
    }
}

