/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.connectors;

import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.examples.java.connectors.SocketSourceFunction;
import org.apache.flink.table.types.DataType;

public final class SocketDynamicTableSource
implements ScanTableSource {
    private final String hostname;
    private final int port;
    private final byte byteDelimiter;
    private final DecodingFormat<DeserializationSchema<RowData>> decodingFormat;
    private final DataType producedDataType;

    public SocketDynamicTableSource(String hostname, int port, byte byteDelimiter, DecodingFormat<DeserializationSchema<RowData>> decodingFormat, DataType producedDataType) {
        this.hostname = hostname;
        this.port = port;
        this.byteDelimiter = byteDelimiter;
        this.decodingFormat = decodingFormat;
        this.producedDataType = producedDataType;
    }

    public ChangelogMode getChangelogMode() {
        return this.decodingFormat.getChangelogMode();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        DeserializationSchema deserializer = (DeserializationSchema)this.decodingFormat.createRuntimeDecoder((DynamicTableSource.Context)runtimeProviderContext, this.producedDataType);
        SocketSourceFunction sourceFunction = new SocketSourceFunction(this.hostname, this.port, this.byteDelimiter, (DeserializationSchema<RowData>)deserializer);
        return SourceFunctionProvider.of((SourceFunction)sourceFunction, (boolean)false);
    }

    public DynamicTableSource copy() {
        return new SocketDynamicTableSource(this.hostname, this.port, this.byteDelimiter, this.decodingFormat, this.producedDataType);
    }

    public String asSummaryString() {
        return "Socket Table Source";
    }
}

