/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.connectors;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.examples.java.connectors.SocketDynamicTableSource;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;

public final class SocketDynamicTableFactory
implements DynamicTableSourceFactory {
    public static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue();
    public static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().noDefaultValue();
    public static final ConfigOption<Integer> BYTE_DELIMITER = ConfigOptions.key((String)"byte-delimiter").intType().defaultValue((Object)10);

    public String factoryIdentifier() {
        return "socket";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(HOSTNAME);
        options.add(PORT);
        options.add(FactoryUtil.FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(BYTE_DELIMITER);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        DecodingFormat decodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT);
        helper.validate();
        ReadableConfig options = helper.getOptions();
        String hostname = (String)options.get(HOSTNAME);
        int port = (Integer)options.get(PORT);
        byte byteDelimiter = (byte)((Integer)options.get(BYTE_DELIMITER)).intValue();
        DataType producedDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        return new SocketDynamicTableSource(hostname, port, byteDelimiter, (DecodingFormat<DeserializationSchema<RowData>>)decodingFormat, producedDataType);
    }
}

