/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.basics;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;

public final class UpdatingTopCityExample {
    public static void main(String[] args) throws Exception {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)settings);
        String populationDirPath = UpdatingTopCityExample.createTemporaryDirectory();
        env.executeSql("CREATE TABLE PopulationUpdates (  city STRING,  state STRING,  update_year INT,  population_diff INT) WITH (  'connector' = 'filesystem',  'path' = '" + populationDirPath + "',  'format' = 'csv')");
        TableResult insertionResult = env.executeSql("INSERT INTO PopulationUpdates VALUES  ('Los Angeles', 'CA', 2013, 13106100),   ('Los Angeles', 'CA', 2014, 72600),   ('Los Angeles', 'CA', 2015, 72300),   ('Chicago', 'IL', 2013, 9553270),   ('Chicago', 'IL', 2014, 11340),   ('Chicago', 'IL', 2015, -6730),   ('Houston', 'TX', 2013, 6330660),   ('Houston', 'TX', 2014, 172960),   ('Houston', 'TX', 2015, 172940),   ('Phoenix', 'AZ', 2013, 4404680),   ('Phoenix', 'AZ', 2014, 86740),   ('Phoenix', 'AZ', 2015, 89700),   ('San Antonio', 'TX', 2013, 2280580),   ('San Antonio', 'TX', 2014, 49180),   ('San Antonio', 'TX', 2015, 50870),   ('San Francisco', 'CA', 2013, 4521310),   ('San Francisco', 'CA', 2014, 65940),   ('San Francisco', 'CA', 2015, 62290),   ('Dallas', 'TX', 2013, 6817520),   ('Dallas', 'TX', 2014, 137740),   ('Dallas', 'TX', 2015, 154020)");
        insertionResult.await();
        Table currentPopulation = env.sqlQuery("SELECT city, state, MAX(update_year) AS latest_year, SUM(population_diff) AS population FROM PopulationUpdates GROUP BY city, state");
        env.createTemporaryView("CurrentPopulation", currentPopulation);
        Table topCitiesPerState = env.sqlQuery("SELECT state, city, latest_year, population FROM   (SELECT DISTINCT state FROM CurrentPopulation) States,  LATERAL (    SELECT city, latest_year, population    FROM CurrentPopulation    WHERE state = States.state    ORDER BY population DESC, latest_year DESC    LIMIT 2  )");
        try (CloseableIterator iterator = topCitiesPerState.execute().collect();){
            ArrayList materializedUpdates = new ArrayList();
            iterator.forEachRemaining(row -> {
                RowKind kind = row.getKind();
                switch (kind) {
                    case INSERT: 
                    case UPDATE_BEFORE: {
                        row.setKind(RowKind.INSERT);
                        materializedUpdates.add(row);
                        break;
                    }
                    case UPDATE_AFTER: 
                    case DELETE: {
                        row.setKind(RowKind.INSERT);
                        materializedUpdates.remove(row);
                    }
                }
            });
            materializedUpdates.forEach(System.out::println);
        }
    }

    private static String createTemporaryDirectory() throws IOException {
        Path tempDirectory = Files.createTempDirectory("population", new FileAttribute[0]);
        return tempDirectory.toString();
    }
}

