/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.scala;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.api.scala.BatchTableEnvironment$;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.examples.scala.TPCHQuery3Table;
import org.apache.flink.table.examples.scala.TPCHQuery3Table$;
import org.apache.flink.table.expressions.Expression;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TPCHQuery3Table$ {
    public static final TPCHQuery3Table$ MODULE$;
    private String lineitemPath;
    private String customerPath;
    private String ordersPath;
    private String outputPath;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;
    private static Symbol symbol$4;
    private static Symbol symbol$5;
    private static Symbol symbol$6;
    private static Symbol symbol$7;
    private static Symbol symbol$8;
    private static Symbol symbol$9;
    private static Symbol symbol$10;

    static {
        symbol$1 = Symbol$.MODULE$.apply("id");
        symbol$2 = Symbol$.MODULE$.apply("extdPrice");
        symbol$3 = Symbol$.MODULE$.apply("discount");
        symbol$4 = Symbol$.MODULE$.apply("shipDate");
        symbol$5 = Symbol$.MODULE$.apply("mktSegment");
        symbol$6 = Symbol$.MODULE$.apply("orderId");
        symbol$7 = Symbol$.MODULE$.apply("custId");
        symbol$8 = Symbol$.MODULE$.apply("orderDate");
        symbol$9 = Symbol$.MODULE$.apply("shipPrio");
        symbol$10 = Symbol$.MODULE$.apply("revenue");
        new TPCHQuery3Table$();
    }

    public void main(String[] args) {
        if (this.parseParameters(args)) {
            Expression date = package$.MODULE$.LiteralStringExpression("1995-03-12").toDate();
            ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            BatchTableEnvironment tEnv = BatchTableEnvironment$.MODULE$.create(env);
            Table lineitems = package$.MODULE$.dataSetConversions(this.getLineitemDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4)})).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$4).toDate()).$greater(date));
            Table customers = package$.MODULE$.dataSetConversions(this.getCustomerDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$5)})).filter(package$.MODULE$.UnresolvedFieldExpression(symbol$5).$eq$eq$eq(package$.MODULE$.string2Literal("AUTOMOBILE")));
            Table orders = package$.MODULE$.dataSetConversions(this.getOrdersDataSet(env)).toTable(tEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$7), package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$9)})).filter(package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$8).toDate()).$less(date));
            Table items = orders.join(customers).where(package$.MODULE$.UnresolvedFieldExpression(symbol$7).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$1))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$9)}).join(lineitems).where(package$.MODULE$.UnresolvedFieldExpression(symbol$6).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$1))).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$2).$times(package$.MODULE$.WithOperations(package$.MODULE$.LiteralFloatExpression(1.0f).toExpr()).$minus(package$.MODULE$.symbol2FieldExpression(symbol$3)))).as(symbol$10, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$9)});
            Table result = items.groupBy(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$9)}).select(new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$6), package$.MODULE$.WithOperations(package$.MODULE$.UnresolvedFieldExpression(symbol$10).sum()).as(symbol$10, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[0])), package$.MODULE$.symbol2FieldExpression(symbol$8), package$.MODULE$.symbol2FieldExpression(symbol$9)}).orderBy(new Expression[]{package$.MODULE$.UnresolvedFieldExpression(symbol$10).desc(), package$.MODULE$.UnresolvedFieldExpression(symbol$8).asc()});
            DataSet qual$1 = package$.MODULE$.table2RowDataSet(result);
            String x$1 = this.outputPath();
            String x$2 = "\n";
            String x$3 = "|";
            FileSystem.WriteMode x$4 = qual$1.writeAsCsv$default$4();
            qual$1.writeAsCsv(x$1, x$2, x$3, x$4);
            env.execute("Scala TPCH Query 3 (Table API Expression) Example");
            return;
        }
    }

    private String lineitemPath() {
        return this.lineitemPath;
    }

    private void lineitemPath_$eq(String x$1) {
        this.lineitemPath = x$1;
    }

    private String customerPath() {
        return this.customerPath;
    }

    private void customerPath_$eq(String x$1) {
        this.customerPath = x$1;
    }

    private String ordersPath() {
        return this.ordersPath;
    }

    private void ordersPath_$eq(String x$1) {
        this.ordersPath = x$1;
    }

    private String outputPath() {
        return this.outputPath;
    }

    private void outputPath_$eq(String x$1) {
        this.outputPath = x$1;
    }

    private boolean parseParameters(String[] args) {
        boolean bl;
        if (args.length == 4) {
            this.lineitemPath_$eq(args[0]);
            this.customerPath_$eq(args[1]);
            this.ordersPath_$eq(args[2]);
            this.outputPath_$eq(args[3]);
            bl = true;
        } else {
            System.err.println("This program expects data from the TPC-H benchmark as input data.\n Due to legal restrictions, we can not ship generated data.\n You can find the TPC-H data generator at http://www.tpc.org/tpch/.\n Usage: TPCHQuery3 <lineitem-csv path> <customer-csv path> <orders-csv path> <result path>");
            bl = false;
        }
        return bl;
    }

    private DataSet<TPCHQuery3Table.Lineitem> getLineitemDataSet(ExecutionEnvironment env) {
        String x$5 = this.lineitemPath();
        String x$6 = "|";
        int[] x$7 = new int[]{0, 5, 6, 10};
        String x$8 = env.readCsvFile$default$2();
        Character x$9 = env.readCsvFile$default$4();
        boolean x$10 = env.readCsvFile$default$5();
        String x$11 = env.readCsvFile$default$6();
        boolean x$12 = env.readCsvFile$default$7();
        String[] x$13 = env.readCsvFile$default$9();
        return env.readCsvFile(x$5, x$8, x$6, x$9, x$10, x$11, x$12, x$7, x$13, ClassTag$.MODULE$.apply(TPCHQuery3Table.Lineitem.class), (TypeInformation)new CaseClassTypeInfo<TPCHQuery3Table.Lineitem>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TPCHQuery3Table.Lineitem> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.4 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                ScalaCaseClassSerializer<TPCHQuery3Table.Lineitem> unused = new ScalaCaseClassSerializer<TPCHQuery3Table.Lineitem>(this, fieldSerializers){

                    public TPCHQuery3Table.Lineitem createInstance(Object[] fields) {
                        return new TPCHQuery3Table.Lineitem(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), (String)fields[3]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }

    private DataSet<TPCHQuery3Table.Customer> getCustomerDataSet(ExecutionEnvironment env) {
        String x$14 = this.customerPath();
        String x$15 = "|";
        int[] x$16 = new int[]{0, 6};
        String x$17 = env.readCsvFile$default$2();
        Character x$18 = env.readCsvFile$default$4();
        boolean x$19 = env.readCsvFile$default$5();
        String x$20 = env.readCsvFile$default$6();
        boolean x$21 = env.readCsvFile$default$7();
        String[] x$22 = env.readCsvFile$default$9();
        return env.readCsvFile(x$14, x$17, x$15, x$18, x$19, x$20, x$21, x$16, x$22, ClassTag$.MODULE$.apply(TPCHQuery3Table.Customer.class), (TypeInformation)new CaseClassTypeInfo<TPCHQuery3Table.Customer>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TPCHQuery3Table.Customer> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.5 $outer;
                    private final ExecutionConfig executionConfig$2;
                    private final TypeSerializer[] fieldSerializers$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$2 = executionConfig$2;
                        this.fieldSerializers$2 = fieldSerializers$2;
                    }
                });
                ScalaCaseClassSerializer<TPCHQuery3Table.Customer> unused = new ScalaCaseClassSerializer<TPCHQuery3Table.Customer>(this, fieldSerializers){

                    public TPCHQuery3Table.Customer createInstance(Object[] fields) {
                        return new TPCHQuery3Table.Customer(BoxesRunTime.unboxToLong((Object)fields[0]), (String)fields[1]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }

    private DataSet<TPCHQuery3Table.Order> getOrdersDataSet(ExecutionEnvironment env) {
        String x$23 = this.ordersPath();
        String x$24 = "|";
        int[] x$25 = new int[]{0, 1, 4, 7};
        String x$26 = env.readCsvFile$default$2();
        Character x$27 = env.readCsvFile$default$4();
        boolean x$28 = env.readCsvFile$default$5();
        String x$29 = env.readCsvFile$default$6();
        boolean x$30 = env.readCsvFile$default$7();
        String[] x$31 = env.readCsvFile$default$9();
        return env.readCsvFile(x$23, x$26, x$24, x$27, x$28, x$29, x$30, x$25, x$31, ClassTag$.MODULE$.apply(TPCHQuery3Table.Order.class), (TypeInformation)new CaseClassTypeInfo<TPCHQuery3Table.Order>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<TPCHQuery3Table.Order> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.6 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<TPCHQuery3Table.Order> unused = new ScalaCaseClassSerializer<TPCHQuery3Table.Order>(this, fieldSerializers){

                    public TPCHQuery3Table.Order createInstance(Object[] fields) {
                        return new TPCHQuery3Table.Order(BoxesRunTime.unboxToLong((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]), (String)fields[2], BoxesRunTime.unboxToLong((Object)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        });
    }

    private TPCHQuery3Table$() {
        MODULE$ = this;
    }
}

