/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.join;

import java.io.Serializable;
import java.util.Random;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.util.ratelimit.RateLimiterStrategy;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connector.datagen.source.DataGeneratorSource;
import org.apache.flink.connector.datagen.source.GeneratorFunction;

public class WindowJoinSampleData {
    static final String[] NAMES = new String[]{"tom", "jerry", "alice", "bob", "john", "grace"};
    static final int GRADE_COUNT = 5;
    static final int SALARY_MAX = 10000;

    public static DataGeneratorSource<Tuple2<String, Integer>> getGradeGeneratorSource(double elementsPerSecond) {
        return WindowJoinSampleData.getTupleGeneratorSource(5, elementsPerSecond);
    }

    public static DataGeneratorSource<Tuple2<String, Integer>> getSalaryGeneratorSource(double elementsPerSecond) {
        return WindowJoinSampleData.getTupleGeneratorSource(10000, elementsPerSecond);
    }

    private static DataGeneratorSource<Tuple2<String, Integer>> getTupleGeneratorSource(int maxValue, double elementsPerSecond) {
        Random rnd = new Random();
        GeneratorFunction & Serializable generatorFunction = (GeneratorFunction & Serializable)index -> new Tuple2((Object)NAMES[rnd.nextInt(NAMES.length)], (Object)(rnd.nextInt(maxValue) + 1));
        return new DataGeneratorSource((GeneratorFunction)generatorFunction, Long.MAX_VALUE, RateLimiterStrategy.perSecond((double)elementsPerSecond), TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, Integer>>(){}));
    }
}

