/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;

public class ThrottledIterator<T>
implements Iterator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Iterator<T> source;
    private final long sleepBatchSize;
    private final long sleepBatchTime;
    private long lastBatchCheckTime;
    private long num;

    public ThrottledIterator(Iterator<T> source, long elementsPerSecond) {
        this.source = Objects.requireNonNull(source);
        if (!(source instanceof Serializable)) {
            throw new IllegalArgumentException("source must be java.io.Serializable");
        }
        if (elementsPerSecond >= 100L) {
            this.sleepBatchSize = elementsPerSecond / 20L;
            this.sleepBatchTime = 50L;
        } else if (elementsPerSecond >= 1L) {
            this.sleepBatchSize = 1L;
            this.sleepBatchTime = 1000L / elementsPerSecond;
        } else {
            throw new IllegalArgumentException("'elements per second' must be positive and not zero");
        }
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public T next() {
        if (this.lastBatchCheckTime > 0L) {
            if (++this.num >= this.sleepBatchSize) {
                this.num = 0L;
                long now = System.currentTimeMillis();
                long elapsed = now - this.lastBatchCheckTime;
                if (elapsed < this.sleepBatchTime) {
                    try {
                        Thread.sleep(this.sleepBatchTime - elapsed);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.lastBatchCheckTime = now;
            }
        } else {
            this.lastBatchCheckTime = System.currentTimeMillis();
        }
        return this.source.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

