/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.changelog.fs.StateChangeSet;
import org.apache.flink.changelog.fs.StateChangeUploadScheduler;
import org.apache.flink.changelog.fs.UploadResult;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

@Internal
public interface StateChangeUploader
extends AutoCloseable {
    public UploadTasksResult upload(Collection<StateChangeUploadScheduler.UploadTask> var1) throws IOException;

    public static final class UploadTasksResult {
        private final Map<StateChangeUploadScheduler.UploadTask, Map<StateChangeSet, Tuple2<Long, Long>>> tasksOffsets;
        private final StreamStateHandle handle;
        private final StreamStateHandle localHandle;

        public UploadTasksResult(Map<StateChangeUploadScheduler.UploadTask, Map<StateChangeSet, Tuple2<Long, Long>>> tasksOffsets, StreamStateHandle handle) {
            this(tasksOffsets, handle, null);
        }

        public UploadTasksResult(Map<StateChangeUploadScheduler.UploadTask, Map<StateChangeSet, Tuple2<Long, Long>>> tasksOffsets, StreamStateHandle handle, @Nullable StreamStateHandle localHandle) {
            this.tasksOffsets = Collections.unmodifiableMap(tasksOffsets);
            this.handle = (StreamStateHandle)Preconditions.checkNotNull((Object)handle);
            this.localHandle = localHandle;
        }

        public void complete() {
            for (Map.Entry<StateChangeUploadScheduler.UploadTask, Map<StateChangeSet, Tuple2<Long, Long>>> entry : this.tasksOffsets.entrySet()) {
                StateChangeUploadScheduler.UploadTask task = entry.getKey();
                Map<StateChangeSet, Tuple2<Long, Long>> offsets = entry.getValue();
                task.complete(this.buildResults(this.handle, offsets));
            }
        }

        private List<UploadResult> buildResults(StreamStateHandle handle, Map<StateChangeSet, Tuple2<Long, Long>> offsets) {
            return offsets.entrySet().stream().map(e -> UploadResult.of(handle, this.localHandle, (StateChangeSet)e.getKey(), (Long)((Tuple2)e.getValue()).f0, (Long)((Tuple2)e.getValue()).f1)).collect(Collectors.toList());
        }

        public long getStateSize() {
            return this.handle.getStateSize();
        }

        public void discard() throws Exception {
            this.handle.discardState();
        }

        @VisibleForTesting
        public StreamStateHandle getStreamStateHandle() {
            return this.handle;
        }
    }
}

