/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.util.FatalExitExceptionHandler;
import org.apache.flink.util.concurrent.IgnoreShutdownRejectedExecutionHandler;
import org.slf4j.Logger;

class SchedulerFactory {
    private SchedulerFactory() {
    }

    public static ScheduledThreadPoolExecutor create(int corePoolSize, String name, Logger log) {
        AtomicInteger cnt = new AtomicInteger(0);
        return new ScheduledThreadPoolExecutor(corePoolSize, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName(name + "-" + cnt.incrementAndGet());
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE);
            return thread;
        }, (RejectedExecutionHandler)new IgnoreShutdownRejectedExecutionHandler(log));
    }
}

