/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.extension.eventtime;

import org.apache.flink.api.common.watermark.Watermark;
import org.apache.flink.datastream.api.extension.eventtime.EventTimeExtension;
import org.apache.flink.datastream.api.extension.eventtime.function.OneInputEventTimeStreamProcessFunction;
import org.apache.flink.datastream.api.extension.eventtime.function.TwoInputBroadcastEventTimeStreamProcessFunction;
import org.apache.flink.datastream.api.extension.eventtime.function.TwoInputNonBroadcastEventTimeStreamProcessFunction;
import org.apache.flink.datastream.api.extension.eventtime.function.TwoOutputEventTimeStreamProcessFunction;
import org.apache.flink.datastream.api.extension.eventtime.strategy.EventTimeWatermarkStrategy;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.eventtime.functions.EventTimeWrappedOneInputStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.eventtime.functions.EventTimeWrappedTwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.eventtime.functions.EventTimeWrappedTwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.eventtime.functions.EventTimeWrappedTwoOutputStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.eventtime.functions.ExtractEventTimeProcessFunction;

public class EventTimeExtensionImpl {
    public static <T> OneInputStreamProcessFunction<T, T> buildAsProcessFunction(EventTimeWatermarkStrategy<T> strategy) {
        return new ExtractEventTimeProcessFunction<T>(strategy);
    }

    public static <IN, OUT> OneInputStreamProcessFunction<IN, OUT> wrapProcessFunction(OneInputEventTimeStreamProcessFunction<IN, OUT> processFunction) {
        return new EventTimeWrappedOneInputStreamProcessFunction<IN, OUT>(processFunction);
    }

    public static <IN, OUT1, OUT2> TwoOutputStreamProcessFunction<IN, OUT1, OUT2> wrapProcessFunction(TwoOutputEventTimeStreamProcessFunction<IN, OUT1, OUT2> processFunction) {
        return new EventTimeWrappedTwoOutputStreamProcessFunction<IN, OUT1, OUT2>(processFunction);
    }

    public static <IN1, IN2, OUT> TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> wrapProcessFunction(TwoInputNonBroadcastEventTimeStreamProcessFunction<IN1, IN2, OUT> processFunction) {
        return new EventTimeWrappedTwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT>(processFunction);
    }

    public static <IN1, IN2, OUT> TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT> wrapProcessFunction(TwoInputBroadcastEventTimeStreamProcessFunction<IN1, IN2, OUT> processFunction) {
        return new EventTimeWrappedTwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT>(processFunction);
    }

    public static boolean isEventTimeExtensionWatermark(Watermark watermark) {
        return EventTimeExtension.isEventTimeWatermark((Watermark)watermark) || EventTimeExtension.isIdleStatusWatermark((Watermark)watermark);
    }
}

