/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.extension.window.operators;

import java.util.Collection;
import org.apache.flink.api.common.state.v2.AppendingState;
import org.apache.flink.api.common.state.v2.ListStateDescriptor;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.datastream.api.common.Collector;
import org.apache.flink.datastream.api.context.PartitionedContext;
import org.apache.flink.datastream.api.context.ProcessingTimeManager;
import org.apache.flink.datastream.api.extension.window.function.TwoInputNonBroadcastWindowStreamProcessFunction;
import org.apache.flink.datastream.api.extension.window.function.WindowProcessFunction;
import org.apache.flink.datastream.impl.context.UnsupportedProcessingTimeManager;
import org.apache.flink.datastream.impl.extension.window.context.DefaultTwoInputWindowContext;
import org.apache.flink.datastream.impl.extension.window.context.WindowTriggerContext;
import org.apache.flink.datastream.impl.extension.window.function.InternalTwoInputWindowStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.window.operators.MergingWindowSet;
import org.apache.flink.datastream.impl.extension.window.utils.WindowUtils;
import org.apache.flink.datastream.impl.operators.BaseKeyedTwoInputNonBroadcastProcessOperator;
import org.apache.flink.runtime.asyncprocessing.operators.AbstractAsyncStateStreamOperator;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.v2.internal.InternalAppendingState;
import org.apache.flink.runtime.state.v2.internal.InternalListState;
import org.apache.flink.runtime.state.v2.internal.InternalMergingState;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TaggedUnion;

public class TwoInputNonBroadcastWindowProcessOperator<K, IN1, IN2, OUT, W extends Window>
extends BaseKeyedTwoInputNonBroadcastProcessOperator<K, IN1, IN2, OUT>
implements Triggerable<K, W> {
    private static final long serialVersionUID = 1L;
    private final TwoInputNonBroadcastWindowStreamProcessFunction<IN1, IN2, OUT> windowProcessFunction;
    protected final long allowedLateness;
    protected transient InternalTimerService<W> internalTimerService;
    private final TypeSerializer<W> windowSerializer;
    private final WindowAssigner<? super TaggedUnion<IN1, IN2>, W> windowAssigner;
    private transient WindowAssigner.WindowAssignerContext windowAssignerContext;
    private final Trigger<? super TaggedUnion<IN1, IN2>, ? super W> trigger;
    private transient WindowTriggerContext<K, ? super TaggedUnion<IN1, IN2>, W> triggerContext;
    private transient DefaultTwoInputWindowContext<K, IN1, IN2, W> windowFunctionContext;
    private final StateDescriptor<IN1> leftWindowStateDescriptor;
    private final StateDescriptor<IN2> rightWindowStateDescriptor;
    private transient InternalAppendingState<K, W, IN1, IN1, StateIterator<IN1>, Iterable<IN1>> leftWindowState;
    private transient InternalAppendingState<K, W, IN2, IN2, StateIterator<IN2>, Iterable<IN2>> rightWindowState;
    private transient InternalMergingState<K, W, IN1, IN1, StateIterator<IN1>, Iterable<IN1>> leftWindowMergingState;
    private transient InternalMergingState<K, W, IN2, IN2, StateIterator<IN2>, Iterable<IN2>> rightWindowMergingState;
    private transient InternalListState<K, VoidNamespace, Tuple2<W, W>> mergingSetsState;

    public TwoInputNonBroadcastWindowProcessOperator(InternalTwoInputWindowStreamProcessFunction<IN1, IN2, OUT, W> windowFunction, WindowAssigner<? super TaggedUnion<IN1, IN2>, W> windowAssigner, Trigger<? super TaggedUnion<IN1, IN2>, ? super W> trigger, TypeSerializer<W> windowSerializer, StateDescriptor<IN1> leftWindowStateDescriptor, StateDescriptor<IN2> rightWindowStateDescriptor, long allowedLateness) {
        super(windowFunction);
        Preconditions.checkArgument((allowedLateness >= 0L ? 1 : 0) != 0);
        this.windowProcessFunction = windowFunction.getWindowProcessFunction();
        this.windowAssigner = windowAssigner;
        this.trigger = trigger;
        this.windowSerializer = windowSerializer;
        this.leftWindowStateDescriptor = leftWindowStateDescriptor;
        this.rightWindowStateDescriptor = rightWindowStateDescriptor;
        this.allowedLateness = allowedLateness;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.internalTimerService = this.getInternalTimerService("process-window-timers", this.windowSerializer, this);
        if (this.leftWindowStateDescriptor != null) {
            this.leftWindowState = (InternalAppendingState)this.getOrCreateKeyedState((Window)this.windowSerializer.createInstance(), this.windowSerializer, this.leftWindowStateDescriptor);
        }
        if (this.rightWindowStateDescriptor != null) {
            this.rightWindowState = (InternalAppendingState)this.getOrCreateKeyedState((Window)this.windowSerializer.createInstance(), this.windowSerializer, this.rightWindowStateDescriptor);
        }
        if (this.windowAssigner instanceof MergingWindowAssigner) {
            if (this.leftWindowState instanceof InternalMergingState) {
                this.leftWindowMergingState = (InternalMergingState)this.leftWindowState;
            } else if (this.leftWindowState != null) {
                throw new IllegalStateException("The window uses a merging assigner, but the window state is not mergeable.");
            }
            if (this.rightWindowState instanceof InternalMergingState) {
                this.rightWindowMergingState = (InternalMergingState)this.rightWindowState;
            } else if (this.rightWindowState != null) {
                throw new IllegalStateException("The window uses a merging assigner, but the window state is not mergeable.");
            }
            Class<Tuple2> typedTuple = Tuple2.class;
            TupleSerializer tupleSerializer = new TupleSerializer(typedTuple, new TypeSerializer[]{this.windowSerializer, this.windowSerializer});
            ListStateDescriptor mergingSetsStateDescriptor = new ListStateDescriptor("merging-window-set", (TypeSerializer)tupleSerializer);
            this.mergingSetsState = (InternalListState)this.getOrCreateKeyedState(VoidNamespaceSerializer.INSTANCE.createInstance(), (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)mergingSetsStateDescriptor);
            this.mergingSetsState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
        }
        this.triggerContext = new WindowTriggerContext<Object, TaggedUnion<IN1, IN2>, W>(null, null, (AbstractStreamOperator<?>)this, this.internalTimerService, this.trigger, this.windowSerializer);
        this.windowAssignerContext = new WindowAssigner.WindowAssignerContext(){

            public long getCurrentProcessingTime() {
                return TwoInputNonBroadcastWindowProcessOperator.this.internalTimerService.currentProcessingTime();
            }
        };
        this.windowFunctionContext = new DefaultTwoInputWindowContext(null, this.leftWindowState, this.rightWindowState, (WindowProcessFunction)this.windowProcessFunction, (AbstractAsyncStateStreamOperator<?>)this, (TypeSerializer<Object>)this.windowSerializer, this.leftWindowMergingState != null);
    }

    @Override
    public void processElement1(StreamRecord<IN1> element) throws Exception {
        Collection elementWindows = this.windowAssigner.assignWindows((Object)TaggedUnion.one((Object)element.getValue()), element.getTimestamp(), this.windowAssignerContext);
        boolean isSkippedElement = true;
        final Object key = this.getCurrentKey();
        if (this.windowAssigner instanceof MergingWindowAssigner) {
            MergingWindowSet<Window> mergingWindows = this.getMergingWindowSet();
            for (Window window : elementWindows) {
                Window actualWindow = mergingWindows.addWindow(window, new MergingWindowSet.MergeFunction<W>(){

                    @Override
                    public void merge(W mergeResult, Collection<W> mergedWindows, W stateWindowResult, Collection<W> mergedStateWindows) throws Exception {
                        if (TwoInputNonBroadcastWindowProcessOperator.this.windowAssigner.isEventTime() && mergeResult.maxTimestamp() + TwoInputNonBroadcastWindowProcessOperator.this.allowedLateness <= TwoInputNonBroadcastWindowProcessOperator.this.internalTimerService.currentWatermark()) {
                            throw new UnsupportedOperationException("The end timestamp of an event-time window cannot become earlier than the current watermark by merging. Current event time: " + TwoInputNonBroadcastWindowProcessOperator.this.internalTimerService.currentWatermark() + " window: " + String.valueOf(mergeResult));
                        }
                        if (!TwoInputNonBroadcastWindowProcessOperator.this.windowAssigner.isEventTime()) {
                            long currentProcessingTime = TwoInputNonBroadcastWindowProcessOperator.this.internalTimerService.currentProcessingTime();
                            if (mergeResult.maxTimestamp() <= currentProcessingTime) {
                                throw new UnsupportedOperationException("The end timestamp of a processing-time window cannot become earlier than the current processing time by merging. Current processing time: " + currentProcessingTime + " window: " + String.valueOf(mergeResult));
                            }
                        }
                        TwoInputNonBroadcastWindowProcessOperator.this.triggerContext.setKey(key);
                        TwoInputNonBroadcastWindowProcessOperator.this.triggerContext.setWindow(mergeResult);
                        TwoInputNonBroadcastWindowProcessOperator.this.triggerContext.onMerge(mergedWindows);
                        for (Window m : mergedWindows) {
                            TwoInputNonBroadcastWindowProcessOperator.this.triggerContext.setWindow(m);
                            TwoInputNonBroadcastWindowProcessOperator.this.triggerContext.clear();
                            WindowUtils.deleteCleanupTimer(m, TwoInputNonBroadcastWindowProcessOperator.this.windowAssigner, TwoInputNonBroadcastWindowProcessOperator.this.triggerContext, TwoInputNonBroadcastWindowProcessOperator.this.allowedLateness);
                        }
                        TwoInputNonBroadcastWindowProcessOperator.this.leftWindowMergingState.mergeNamespaces(stateWindowResult, mergedStateWindows);
                        TwoInputNonBroadcastWindowProcessOperator.this.rightWindowMergingState.mergeNamespaces(stateWindowResult, mergedStateWindows);
                    }
                });
                if (WindowUtils.isWindowLate(actualWindow, this.windowAssigner, this.internalTimerService, this.allowedLateness)) {
                    mergingWindows.retireWindow(actualWindow);
                    continue;
                }
                isSkippedElement = false;
                Window stateWindow = mergingWindows.getStateWindow(actualWindow);
                if (stateWindow == null) {
                    throw new IllegalStateException("Window " + String.valueOf(window) + " is not in in-flight window set.");
                }
                this.leftWindowState.setCurrentNamespace((Object)stateWindow);
                this.collector.setTimestamp(window.maxTimestamp());
                this.windowFunctionContext.setWindow(window);
                this.windowProcessFunction.onRecord1(element.getValue(), (Collector)this.collector, (PartitionedContext)this.partitionedContext, this.windowFunctionContext);
                this.triggerContext.setKey(key);
                this.triggerContext.setWindow(actualWindow);
                TriggerResult triggerResult = this.triggerContext.onElement(new StreamRecord((Object)TaggedUnion.one((Object)element.getValue()), element.getTimestamp()));
                if (triggerResult.isFire()) {
                    this.emitWindowContents(actualWindow);
                }
                if (triggerResult.isPurge()) {
                    this.leftWindowState.clear();
                    this.rightWindowState.clear();
                }
                WindowUtils.registerCleanupTimer(actualWindow, this.windowAssigner, this.triggerContext, this.allowedLateness);
            }
            mergingWindows.persist();
        } else {
            for (Window window : elementWindows) {
                if (WindowUtils.isWindowLate(window, this.windowAssigner, this.internalTimerService, this.allowedLateness)) continue;
                isSkippedElement = false;
                this.leftWindowState.setCurrentNamespace((Object)window);
                this.collector.setTimestamp(window.maxTimestamp());
                this.windowFunctionContext.setWindow(window);
                this.windowProcessFunction.onRecord1(element.getValue(), (Collector)this.collector, (PartitionedContext)this.partitionedContext, this.windowFunctionContext);
                this.triggerContext.setKey(key);
                this.triggerContext.setWindow(window);
                TriggerResult triggerResult = this.triggerContext.onElement(new StreamRecord((Object)TaggedUnion.one((Object)element.getValue()), element.getTimestamp()));
                if (triggerResult.isFire()) {
                    this.emitWindowContents(window);
                }
                if (triggerResult.isPurge()) {
                    this.leftWindowState.clear();
                    this.rightWindowState.clear();
                }
                WindowUtils.registerCleanupTimer(window, this.windowAssigner, this.triggerContext, this.allowedLateness);
            }
        }
        if (isSkippedElement && WindowUtils.isElementLate(element, this.windowAssigner, this.allowedLateness, this.internalTimerService)) {
            this.windowProcessFunction.onLateRecord1(element.getValue(), (Collector)this.collector, (PartitionedContext)this.partitionedContext);
        }
    }

    @Override
    public void processElement2(StreamRecord<IN2> element) throws Exception {
        Collection elementWindows = this.windowAssigner.assignWindows((Object)TaggedUnion.two((Object)element.getValue()), element.getTimestamp(), this.windowAssignerContext);
        boolean isSkippedElement = true;
        final Object key = this.getCurrentKey();
        if (this.windowAssigner instanceof MergingWindowAssigner) {
            MergingWindowSet<Window> mergingWindows = this.getMergingWindowSet();
            for (Window window : elementWindows) {
                Window actualWindow = mergingWindows.addWindow(window, new MergingWindowSet.MergeFunction<W>(){

                    @Override
                    public void merge(W mergeResult, Collection<W> mergedWindows, W stateWindowResult, Collection<W> mergedStateWindows) throws Exception {
                        if (TwoInputNonBroadcastWindowProcessOperator.this.windowAssigner.isEventTime() && mergeResult.maxTimestamp() + TwoInputNonBroadcastWindowProcessOperator.this.allowedLateness <= TwoInputNonBroadcastWindowProcessOperator.this.internalTimerService.currentWatermark()) {
                            throw new UnsupportedOperationException("The end timestamp of an event-time window cannot become earlier than the current watermark by merging. Current event time: " + TwoInputNonBroadcastWindowProcessOperator.this.internalTimerService.currentWatermark() + " window: " + String.valueOf(mergeResult));
                        }
                        if (!TwoInputNonBroadcastWindowProcessOperator.this.windowAssigner.isEventTime()) {
                            long currentProcessingTime = TwoInputNonBroadcastWindowProcessOperator.this.internalTimerService.currentProcessingTime();
                            if (mergeResult.maxTimestamp() <= currentProcessingTime) {
                                throw new UnsupportedOperationException("The end timestamp of a processing-time window cannot become earlier than the current processing time by merging. Current processing time: " + currentProcessingTime + " window: " + String.valueOf(mergeResult));
                            }
                        }
                        TwoInputNonBroadcastWindowProcessOperator.this.triggerContext.setKey(key);
                        TwoInputNonBroadcastWindowProcessOperator.this.triggerContext.setWindow(mergeResult);
                        TwoInputNonBroadcastWindowProcessOperator.this.triggerContext.onMerge(mergedWindows);
                        for (Window m : mergedWindows) {
                            TwoInputNonBroadcastWindowProcessOperator.this.triggerContext.setWindow(m);
                            TwoInputNonBroadcastWindowProcessOperator.this.triggerContext.clear();
                            WindowUtils.deleteCleanupTimer(m, TwoInputNonBroadcastWindowProcessOperator.this.windowAssigner, TwoInputNonBroadcastWindowProcessOperator.this.triggerContext, TwoInputNonBroadcastWindowProcessOperator.this.allowedLateness);
                        }
                        TwoInputNonBroadcastWindowProcessOperator.this.leftWindowMergingState.mergeNamespaces(stateWindowResult, mergedStateWindows);
                        TwoInputNonBroadcastWindowProcessOperator.this.rightWindowMergingState.mergeNamespaces(stateWindowResult, mergedStateWindows);
                    }
                });
                if (WindowUtils.isWindowLate(actualWindow, this.windowAssigner, this.internalTimerService, this.allowedLateness)) {
                    mergingWindows.retireWindow(actualWindow);
                    continue;
                }
                isSkippedElement = false;
                Window stateWindow = mergingWindows.getStateWindow(actualWindow);
                if (stateWindow == null) {
                    throw new IllegalStateException("Window " + String.valueOf(window) + " is not in in-flight window set.");
                }
                this.rightWindowState.setCurrentNamespace((Object)stateWindow);
                this.collector.setTimestamp(window.maxTimestamp());
                this.windowFunctionContext.setWindow(window);
                this.windowProcessFunction.onRecord2(element.getValue(), (Collector)this.collector, (PartitionedContext)this.partitionedContext, this.windowFunctionContext);
                this.triggerContext.setKey(key);
                this.triggerContext.setWindow(actualWindow);
                TriggerResult triggerResult = this.triggerContext.onElement(new StreamRecord((Object)TaggedUnion.two((Object)element.getValue()), element.getTimestamp()));
                if (triggerResult.isFire()) {
                    this.emitWindowContents(actualWindow);
                }
                if (triggerResult.isPurge()) {
                    this.leftWindowState.clear();
                    this.rightWindowState.clear();
                }
                WindowUtils.registerCleanupTimer(actualWindow, this.windowAssigner, this.triggerContext, this.allowedLateness);
            }
            mergingWindows.persist();
        } else {
            for (Window window : elementWindows) {
                if (WindowUtils.isWindowLate(window, this.windowAssigner, this.internalTimerService, this.allowedLateness)) continue;
                isSkippedElement = false;
                this.rightWindowState.setCurrentNamespace((Object)window);
                this.collector.setTimestamp(window.maxTimestamp());
                this.windowFunctionContext.setWindow(window);
                this.windowProcessFunction.onRecord2(element.getValue(), (Collector)this.collector, (PartitionedContext)this.partitionedContext, this.windowFunctionContext);
                this.triggerContext.setKey(key);
                this.triggerContext.setWindow(window);
                TriggerResult triggerResult = this.triggerContext.onElement(new StreamRecord((Object)TaggedUnion.two((Object)element.getValue()), element.getTimestamp()));
                if (triggerResult.isFire()) {
                    this.emitWindowContents(window);
                }
                if (triggerResult.isPurge()) {
                    this.leftWindowState.clear();
                    this.rightWindowState.clear();
                }
                WindowUtils.registerCleanupTimer(window, this.windowAssigner, this.triggerContext, this.allowedLateness);
            }
        }
        if (isSkippedElement && WindowUtils.isElementLate(element, this.windowAssigner, this.allowedLateness, this.internalTimerService)) {
            this.windowProcessFunction.onLateRecord2(element.getValue(), (Collector)this.collector, (PartitionedContext)this.partitionedContext);
        }
    }

    public void onEventTime(InternalTimer<K, W> timer) throws Exception {
        MergingWindowSet<W> mergingWindows;
        this.triggerContext.setKey(timer.getKey());
        this.triggerContext.setWindow((Window)timer.getNamespace());
        if (this.windowAssigner instanceof MergingWindowAssigner) {
            mergingWindows = this.getMergingWindowSet();
            W stateWindow = mergingWindows.getStateWindow(this.triggerContext.getWindow());
            if (stateWindow == null) {
                return;
            }
            this.leftWindowState.setCurrentNamespace(stateWindow);
            this.rightWindowState.setCurrentNamespace(stateWindow);
        } else {
            this.leftWindowState.setCurrentNamespace(this.triggerContext.getWindow());
            this.rightWindowState.setCurrentNamespace(this.triggerContext.getWindow());
            mergingWindows = null;
        }
        TriggerResult triggerResult = this.triggerContext.onEventTime(timer.getTimestamp());
        if (triggerResult.isFire()) {
            this.emitWindowContents(this.triggerContext.getWindow());
        }
        if (triggerResult.isPurge()) {
            this.leftWindowState.clear();
            this.rightWindowState.clear();
        }
        if (this.windowAssigner.isEventTime() && WindowUtils.isCleanupTime(this.triggerContext.getWindow(), timer.getTimestamp(), this.windowAssigner, this.allowedLateness)) {
            this.clearAllState(this.triggerContext.getWindow(), (AppendingState<IN1, StateIterator<IN1>, Iterable<IN1>>)this.leftWindowState, (AppendingState<IN2, StateIterator<IN2>, Iterable<IN2>>)this.rightWindowState, mergingWindows);
        }
        if (mergingWindows != null) {
            mergingWindows.persist();
        }
    }

    public void onProcessingTime(InternalTimer<K, W> timer) throws Exception {
        MergingWindowSet<W> mergingWindows;
        this.triggerContext.setKey(timer.getKey());
        this.triggerContext.setWindow((Window)timer.getNamespace());
        if (this.windowAssigner instanceof MergingWindowAssigner) {
            mergingWindows = this.getMergingWindowSet();
            W stateWindow = mergingWindows.getStateWindow(this.triggerContext.getWindow());
            if (stateWindow == null) {
                return;
            }
            this.leftWindowState.setCurrentNamespace(stateWindow);
            this.rightWindowState.setCurrentNamespace(stateWindow);
        } else {
            this.leftWindowState.setCurrentNamespace(this.triggerContext.getWindow());
            this.rightWindowState.setCurrentNamespace(this.triggerContext.getWindow());
            mergingWindows = null;
        }
        TriggerResult triggerResult = this.triggerContext.onProcessingTime(timer.getTimestamp());
        if (triggerResult.isFire()) {
            this.emitWindowContents(this.triggerContext.getWindow());
        }
        if (triggerResult.isPurge()) {
            this.leftWindowState.clear();
            this.rightWindowState.clear();
        }
        if (!this.windowAssigner.isEventTime() && WindowUtils.isCleanupTime(this.triggerContext.getWindow(), timer.getTimestamp(), this.windowAssigner, this.allowedLateness)) {
            this.clearAllState(this.triggerContext.getWindow(), (AppendingState<IN1, StateIterator<IN1>, Iterable<IN1>>)this.leftWindowState, (AppendingState<IN2, StateIterator<IN2>, Iterable<IN2>>)this.rightWindowState, mergingWindows);
        }
        if (mergingWindows != null) {
            mergingWindows.persist();
        }
    }

    @Override
    protected ProcessingTimeManager getProcessingTimeManager() {
        return UnsupportedProcessingTimeManager.INSTANCE;
    }

    private void clearAllState(W window, AppendingState<IN1, StateIterator<IN1>, Iterable<IN1>> leftWindowState, AppendingState<IN2, StateIterator<IN2>, Iterable<IN2>> rightWindowState, MergingWindowSet<W> mergingWindows) throws Exception {
        leftWindowState.clear();
        rightWindowState.clear();
        this.triggerContext.clear();
        this.windowFunctionContext.setWindow(window);
        this.windowProcessFunction.onClear((Collector)this.collector, (PartitionedContext)this.partitionedContext, this.windowFunctionContext);
        if (mergingWindows != null) {
            mergingWindows.retireWindow(window);
            mergingWindows.persist();
        }
    }

    private void emitWindowContents(W window) throws Exception {
        this.collector.setTimestamp(window.maxTimestamp());
        this.windowFunctionContext.setWindow(window);
        this.windowProcessFunction.onTrigger((Collector)this.collector, (PartitionedContext)this.partitionedContext, this.windowFunctionContext);
    }

    protected MergingWindowSet<W> getMergingWindowSet() throws Exception {
        MergingWindowAssigner mergingAssigner = (MergingWindowAssigner)this.windowAssigner;
        return new MergingWindowSet<W>(mergingAssigner, this.mergingSetsState);
    }
}

