/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.datastream.api.context.NonPartitionedContext;
import org.apache.flink.datastream.api.context.PartitionedContext;
import org.apache.flink.datastream.api.context.ProcessingTimeManager;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;
import org.apache.flink.datastream.impl.common.OutputCollector;
import org.apache.flink.datastream.impl.common.TimestampCollector;
import org.apache.flink.datastream.impl.context.DefaultNonPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultRuntimeContext;
import org.apache.flink.datastream.impl.context.UnsupportedProcessingTimeManager;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class ProcessOperator<IN, OUT>
extends AbstractUdfStreamOperator<OUT, OneInputStreamProcessFunction<IN, OUT>>
implements OneInputStreamOperator<IN, OUT>,
BoundedOneInput {
    protected transient DefaultRuntimeContext context;
    protected transient DefaultPartitionedContext partitionedContext;
    protected transient NonPartitionedContext<OUT> nonPartitionedContext;
    protected transient TimestampCollector<OUT> outputCollector;

    public ProcessOperator(OneInputStreamProcessFunction<IN, OUT> userFunction) {
        super(userFunction);
    }

    public void open() throws Exception {
        super.open();
        StreamingRuntimeContext operatorContext = this.getRuntimeContext();
        TaskInfo taskInfo = operatorContext.getTaskInfo();
        this.context = new DefaultRuntimeContext(operatorContext.getJobInfo().getJobName(), operatorContext.getJobType(), taskInfo.getNumberOfParallelSubtasks(), taskInfo.getMaxNumberOfParallelSubtasks(), taskInfo.getTaskName(), (MetricGroup)operatorContext.getMetricGroup());
        this.partitionedContext = new DefaultPartitionedContext(this.context, this::currentKey, arg_0 -> ((ProcessOperator)this).setCurrentKey(arg_0), this.getProcessingTimeManager(), operatorContext, (OperatorStateStore)this.getOperatorStateBackend());
        this.outputCollector = this.getOutputCollector();
        this.nonPartitionedContext = this.getNonPartitionedContext();
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        this.outputCollector.setTimestampFromStreamRecord(element);
        ((OneInputStreamProcessFunction)this.userFunction).processRecord(element.getValue(), this.outputCollector, (PartitionedContext)this.partitionedContext);
    }

    protected TimestampCollector<OUT> getOutputCollector() {
        return new OutputCollector(this.output);
    }

    public void endInput() throws Exception {
        ((OneInputStreamProcessFunction)this.userFunction).endInput(this.nonPartitionedContext);
    }

    protected Object currentKey() {
        throw new UnsupportedOperationException("The key is only defined for keyed operator");
    }

    protected ProcessingTimeManager getProcessingTimeManager() {
        return UnsupportedProcessingTimeManager.INSTANCE;
    }

    protected NonPartitionedContext<OUT> getNonPartitionedContext() {
        return new DefaultNonPartitionedContext<OUT>(this.context, this.partitionedContext, this.outputCollector, false, null);
    }
}

