/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.api.extension.window.strategy;

import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.datastream.api.extension.window.strategy.GlobalWindowStrategy;
import org.apache.flink.datastream.api.extension.window.strategy.SessionWindowStrategy;
import org.apache.flink.datastream.api.extension.window.strategy.SlidingTimeWindowStrategy;
import org.apache.flink.datastream.api.extension.window.strategy.TumblingTimeWindowStrategy;

@Experimental
public class WindowStrategy
implements Serializable {
    public static final TimeType PROCESSING_TIME = TimeType.PROCESSING;
    public static final TimeType EVENT_TIME = TimeType.EVENT;

    public static WindowStrategy global() {
        return new GlobalWindowStrategy();
    }

    public static WindowStrategy tumbling(Duration windowSize) {
        return new TumblingTimeWindowStrategy(windowSize);
    }

    public static WindowStrategy tumbling(Duration windowSize, TimeType timeType) {
        return new TumblingTimeWindowStrategy(windowSize, timeType);
    }

    public static WindowStrategy tumbling(Duration windowSize, TimeType timeType, Duration allowedLateness) {
        return new TumblingTimeWindowStrategy(windowSize, timeType, allowedLateness);
    }

    public static WindowStrategy sliding(Duration windowSize, Duration windowSlideInterval) {
        return new SlidingTimeWindowStrategy(windowSize, windowSlideInterval);
    }

    public static WindowStrategy sliding(Duration windowSize, Duration windowSlideInterval, TimeType timeType) {
        return new SlidingTimeWindowStrategy(windowSize, windowSlideInterval, timeType);
    }

    public static WindowStrategy sliding(Duration windowSize, Duration windowSlideInterval, TimeType timeType, Duration allowedLateness) {
        return new SlidingTimeWindowStrategy(windowSize, windowSlideInterval, timeType, allowedLateness);
    }

    public static WindowStrategy session(Duration sessionGap) {
        return new SessionWindowStrategy(sessionGap);
    }

    public static WindowStrategy session(Duration sessionGap, TimeType timeType) {
        return new SessionWindowStrategy(sessionGap, timeType);
    }

    @Experimental
    public static enum TimeType {
        PROCESSING,
        EVENT;

    }
}

