/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.api.extension.eventtime.strategy;

import java.time.Duration;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.datastream.api.extension.eventtime.strategy.EventTimeExtractor;
import org.apache.flink.datastream.api.extension.eventtime.strategy.EventTimeWatermarkStrategy;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;

@Experimental
public class EventTimeWatermarkGeneratorBuilder<T> {
    private EventTimeExtractor<T> eventTimeExtractor;
    private EventTimeWatermarkStrategy.EventTimeWatermarkGenerateMode generateMode = EventTimeWatermarkStrategy.EventTimeWatermarkGenerateMode.PERIODIC;
    private Duration periodicWatermarkInterval = Duration.ZERO;
    private Duration idleTimeout = Duration.ZERO;
    private Duration maxOutOfOrderTime = Duration.ZERO;

    public EventTimeWatermarkGeneratorBuilder(EventTimeExtractor<T> eventTimeExtractor) {
        this.eventTimeExtractor = eventTimeExtractor;
    }

    public EventTimeWatermarkGeneratorBuilder<T> withIdleness(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public EventTimeWatermarkGeneratorBuilder<T> withMaxOutOfOrderTime(Duration maxOutOfOrderTime) {
        this.maxOutOfOrderTime = maxOutOfOrderTime;
        return this;
    }

    public EventTimeWatermarkGeneratorBuilder<T> noWatermark() {
        this.generateMode = EventTimeWatermarkStrategy.EventTimeWatermarkGenerateMode.NO_WATERMARK;
        return this;
    }

    public EventTimeWatermarkGeneratorBuilder<T> periodicWatermark() {
        this.generateMode = EventTimeWatermarkStrategy.EventTimeWatermarkGenerateMode.PERIODIC;
        return this;
    }

    public EventTimeWatermarkGeneratorBuilder<T> periodicWatermark(Duration periodicWatermarkInterval) {
        this.generateMode = EventTimeWatermarkStrategy.EventTimeWatermarkGenerateMode.PERIODIC;
        this.periodicWatermarkInterval = periodicWatermarkInterval;
        return this;
    }

    public EventTimeWatermarkGeneratorBuilder<T> perEventWatermark() {
        this.generateMode = EventTimeWatermarkStrategy.EventTimeWatermarkGenerateMode.PER_EVENT;
        return this;
    }

    public OneInputStreamProcessFunction<T, T> buildAsProcessFunction() {
        EventTimeWatermarkStrategy<T> watermarkStrategy = new EventTimeWatermarkStrategy<T>(this.eventTimeExtractor, this.generateMode, this.periodicWatermarkInterval, this.idleTimeout, this.maxOutOfOrderTime);
        try {
            return (OneInputStreamProcessFunction)EventTimeWatermarkGeneratorBuilder.getEventTimeExtensionImplClass().getMethod("buildAsProcessFunction", EventTimeWatermarkStrategy.class).invoke(null, watermarkStrategy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> getEventTimeExtensionImplClass() {
        try {
            return Class.forName("org.apache.flink.datastream.impl.extension.eventtime.EventTimeExtensionImpl");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Please ensure that flink-datastream in your class path");
        }
    }
}

