/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.container.entrypoint;

import java.io.File;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.deployment.application.ApplicationClusterEntryPoint;
import org.apache.flink.client.program.DefaultPackagedProgramRetriever;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.artifact.ArtifactFetchManager;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptionsInternal;
import org.apache.flink.container.entrypoint.StandaloneApplicationClusterConfiguration;
import org.apache.flink.container.entrypoint.StandaloneApplicationClusterConfigurationParserFactory;
import org.apache.flink.core.execution.RestoreMode;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.runtime.entrypoint.EntrypointClusterConfiguration;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManagerFactory;
import org.apache.flink.runtime.security.contexts.SecurityContext;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.slf4j.Logger;

@Internal
public final class StandaloneApplicationClusterEntryPoint
extends ApplicationClusterEntryPoint {
    private StandaloneApplicationClusterEntryPoint(Configuration configuration, PackagedProgram program) {
        super(configuration, program, (ResourceManagerFactory)StandaloneResourceManagerFactory.getInstance());
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)StandaloneApplicationClusterEntryPoint.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        StandaloneApplicationClusterConfiguration clusterConfiguration = (StandaloneApplicationClusterConfiguration)((Object)ClusterEntrypointUtils.parseParametersOrExit((String[])args, (ParserResultFactory)new StandaloneApplicationClusterConfigurationParserFactory(), StandaloneApplicationClusterEntryPoint.class));
        Configuration configuration = StandaloneApplicationClusterEntryPoint.loadConfigurationFromClusterConfig(clusterConfiguration);
        if (clusterConfiguration.getSavepointRestoreSettings().getRestoreMode().equals((Object)RestoreMode.LEGACY)) {
            LOG.warn("The {} restore mode is deprecated, please use {} or {} mode instead.", new Object[]{RestoreMode.LEGACY, RestoreMode.CLAIM, RestoreMode.NO_CLAIM});
        }
        PackagedProgram program = null;
        try {
            PluginManager pluginManager = PluginUtils.createPluginManagerFromRootFolder((Configuration)configuration);
            LOG.info("Install default filesystem for fetching user artifacts in Standalone Application Mode.");
            FileSystem.initialize((Configuration)configuration, (PluginManager)pluginManager);
            SecurityContext securityContext = StandaloneApplicationClusterEntryPoint.installSecurityContext((Configuration)configuration);
            program = (PackagedProgram)securityContext.runSecured(() -> StandaloneApplicationClusterEntryPoint.getPackagedProgram(clusterConfiguration, configuration));
        }
        catch (Exception e) {
            LOG.error("Could not create application program.", (Throwable)e);
            System.exit(1);
        }
        try {
            StandaloneApplicationClusterEntryPoint.configureExecution((Configuration)configuration, program);
        }
        catch (Exception e) {
            LOG.error("Could not apply application configuration.", (Throwable)e);
            System.exit(1);
        }
        StandaloneApplicationClusterEntryPoint entrypoint = new StandaloneApplicationClusterEntryPoint(configuration, program);
        ClusterEntrypoint.runClusterEntrypoint((ClusterEntrypoint)entrypoint);
    }

    protected boolean supportsReactiveMode() {
        return true;
    }

    @VisibleForTesting
    static Configuration loadConfigurationFromClusterConfig(StandaloneApplicationClusterConfiguration clusterConfiguration) {
        Configuration configuration = StandaloneApplicationClusterEntryPoint.loadConfiguration((EntrypointClusterConfiguration)clusterConfiguration);
        StandaloneApplicationClusterEntryPoint.setStaticJobId(clusterConfiguration, configuration);
        SavepointRestoreSettings.toConfiguration((SavepointRestoreSettings)clusterConfiguration.getSavepointRestoreSettings(), (Configuration)configuration);
        return configuration;
    }

    private static PackagedProgram getPackagedProgram(StandaloneApplicationClusterConfiguration clusterConfiguration, Configuration flinkConfiguration) throws Exception {
        File userLibDir = ClusterEntrypointUtils.tryFindUserLibDirectory().orElse(null);
        File jobJar = null;
        List artifacts = null;
        if (clusterConfiguration.hasJars()) {
            ArtifactFetchManager fetchMgr = new ArtifactFetchManager(flinkConfiguration);
            ArtifactFetchManager.Result res = fetchMgr.fetchArtifacts(clusterConfiguration.getJars());
            jobJar = res.getJobJar();
            artifacts = res.getArtifacts();
        }
        DefaultPackagedProgramRetriever programRetriever = DefaultPackagedProgramRetriever.create((File)userLibDir, jobJar, artifacts, (String)clusterConfiguration.getJobClassName(), (String[])clusterConfiguration.getArgs(), (Configuration)flinkConfiguration);
        return programRetriever.getPackagedProgram();
    }

    private static void setStaticJobId(StandaloneApplicationClusterConfiguration clusterConfiguration, Configuration configuration) {
        JobID jobId = clusterConfiguration.getJobId();
        if (jobId != null) {
            configuration.set(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID, (Object)jobId.toHexString());
        }
    }
}

