/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.container.entrypoint;

import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.container.entrypoint.StandaloneApplicationClusterConfiguration;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.parser.CommandLineOptions;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

public class StandaloneApplicationClusterConfigurationParserFactory
implements ParserResultFactory<StandaloneApplicationClusterConfiguration> {
    private static final Option JOB_CLASS_NAME_OPTION = Option.builder((String)"j").longOpt("job-classname").required(false).hasArg(true).argName("job class name").desc("Class name of the job to run.").build();
    private static final Option JOB_ID_OPTION = Option.builder((String)"jid").longOpt("job-id").required(false).hasArg(true).argName("job id").desc("Job ID of the job to run.").build();
    private static final Option JARS_OPTION = Option.builder((String)"jars").longOpt("jars").required(false).hasArgs().valueSeparator(',').argName("jar file(s) for job").desc("Jar file of the job to run.").build();

    public Options getOptions() {
        Options options = new Options();
        options.addOption(CommandLineOptions.CONFIG_DIR_OPTION);
        options.addOption(JARS_OPTION);
        options.addOption(CommandLineOptions.REST_PORT_OPTION);
        options.addOption(JOB_CLASS_NAME_OPTION);
        options.addOption(JOB_ID_OPTION);
        options.addOption(CommandLineOptions.DYNAMIC_PROPERTY_OPTION);
        options.addOption(CommandLineOptions.HOST_OPTION);
        options.addOption(CliFrontendParser.SAVEPOINT_PATH_OPTION);
        options.addOption(CliFrontendParser.SAVEPOINT_ALLOW_NON_RESTORED_OPTION);
        return options;
    }

    public StandaloneApplicationClusterConfiguration createResult(@Nonnull CommandLine commandLine) throws FlinkParseException {
        String configDir = commandLine.getOptionValue(CommandLineOptions.CONFIG_DIR_OPTION.getOpt());
        Properties dynamicProperties = commandLine.getOptionProperties(CommandLineOptions.DYNAMIC_PROPERTY_OPTION.getOpt());
        int restPort = this.getRestPort(commandLine);
        String hostname = commandLine.getOptionValue(CommandLineOptions.HOST_OPTION.getOpt());
        SavepointRestoreSettings savepointRestoreSettings = CliFrontendParser.createSavepointRestoreSettings((CommandLine)commandLine);
        JobID jobId = StandaloneApplicationClusterConfigurationParserFactory.getJobId(commandLine);
        String jobClassName = commandLine.getOptionValue(JOB_CLASS_NAME_OPTION.getOpt());
        String[] jarFiles = commandLine.getOptionValues(JARS_OPTION.getOpt());
        return new StandaloneApplicationClusterConfiguration(configDir, dynamicProperties, commandLine.getArgs(), hostname, restPort, savepointRestoreSettings, jobId, jobClassName, jarFiles);
    }

    private int getRestPort(CommandLine commandLine) throws FlinkParseException {
        String restPortString = commandLine.getOptionValue(CommandLineOptions.REST_PORT_OPTION.getOpt(), "-1");
        try {
            return Integer.parseInt(restPortString);
        }
        catch (NumberFormatException e) {
            throw StandaloneApplicationClusterConfigurationParserFactory.createFlinkParseException(CommandLineOptions.REST_PORT_OPTION, e);
        }
    }

    @Nullable
    private static JobID getJobId(CommandLine commandLine) throws FlinkParseException {
        String jobId = commandLine.getOptionValue(JOB_ID_OPTION.getOpt());
        if (jobId == null) {
            return null;
        }
        try {
            return JobID.fromHexString((String)jobId);
        }
        catch (IllegalArgumentException e) {
            throw StandaloneApplicationClusterConfigurationParserFactory.createFlinkParseException(JOB_ID_OPTION, e);
        }
    }

    private static FlinkParseException createFlinkParseException(Option option, Exception cause) {
        return new FlinkParseException(String.format("Failed to parse '--%s' option", option.getLongOpt()), (Throwable)cause);
    }
}

