/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

public class TestcontainersSettings {
    private final Network network;
    private final Logger logger;
    private final String baseImage;
    private final Map<String, String> envVars;
    private final Collection<GenericContainer<?>> dependencies;

    private TestcontainersSettings(Builder builder) {
        this.network = builder.network;
        this.baseImage = builder.baseImage;
        this.logger = builder.logger;
        this.envVars = builder.envVars;
        this.dependencies = builder.dependingContainers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TestcontainersSettings defaultSettings() {
        return TestcontainersSettings.builder().build();
    }

    public Network getNetwork() {
        return this.network;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public Collection<GenericContainer<?>> getDependencies() {
        return this.dependencies;
    }

    public static final class Builder {
        private Network network = Network.newNetwork();
        private String baseImage;
        private Logger logger;
        private final Map<String, String> envVars = new HashMap<String, String>();
        private final Collection<GenericContainer<?>> dependingContainers = new ArrayList();

        private Builder() {
        }

        public Builder environmentVariable(String name, String value) {
            this.envVars.put(name, value);
            return this;
        }

        public Builder dependsOn(GenericContainer<?> container) {
            container.withNetwork(this.network);
            this.dependingContainers.add(container);
            return this;
        }

        public Builder network(Network network) {
            this.network = network;
            return this;
        }

        public Builder baseImage(String baseImage) {
            this.baseImage = baseImage;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public TestcontainersSettings build() {
            return new TestcontainersSettings(this);
        }
    }
}

