/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.testframe.external.sink;

import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.util.Preconditions;

public class TestingSinkSettings {
    private final CheckpointingMode checkpointingMode;

    public static Builder builder() {
        return new Builder();
    }

    private TestingSinkSettings(CheckpointingMode checkpointingMode) {
        this.checkpointingMode = checkpointingMode;
    }

    public CheckpointingMode getCheckpointingMode() {
        return this.checkpointingMode;
    }

    public static class Builder {
        private CheckpointingMode checkpointingMode;

        public Builder setCheckpointingMode(CheckpointingMode checkpointingMode) {
            this.checkpointingMode = checkpointingMode;
            return this;
        }

        public TestingSinkSettings build() {
            this.sanityCheck();
            return new TestingSinkSettings(this.checkpointingMode);
        }

        private void sanityCheck() {
            Preconditions.checkNotNull((Object)this.checkpointingMode, (String)"Checkpointing mode is not specified");
        }
    }
}

