/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.utils;

import io.debezium.data.Envelope;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cdc.debezium.DebeziumSourceFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;

public class AssertUtils {
    public static void assertInsert(SourceRecord record, boolean keyExpected) {
        if (keyExpected) {
            Assertions.assertThat((Object)record.key()).isNotNull();
            Assertions.assertThat((Object)record.keySchema()).isNotNull();
        } else {
            Assertions.assertThat((Object)record.key()).isNull();
            Assertions.assertThat((Object)record.keySchema()).isNull();
        }
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo(Envelope.Operation.CREATE.code());
        Assertions.assertThat((Object)value.get("after")).isNotNull();
        Assertions.assertThat((Object)value.get("before")).isNull();
    }

    public static void assertRead(SourceRecord record) {
        Assertions.assertThat((Object)record.key()).isNotNull();
        Assertions.assertThat((Object)record.keySchema()).isNotNull();
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo(Envelope.Operation.READ.code());
        Assertions.assertThat((Object)value.get("after")).isNotNull();
        Assertions.assertThat((Object)value.get("before")).isNull();
    }

    public static void assertUpdate(SourceRecord record, boolean keyExpected) {
        if (keyExpected) {
            Assertions.assertThat((Object)record.key()).isNotNull();
            Assertions.assertThat((Object)record.keySchema()).isNotNull();
        } else {
            Assertions.assertThat((Object)record.key()).isNull();
            Assertions.assertThat((Object)record.keySchema()).isNull();
        }
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo(Envelope.Operation.UPDATE.code());
        Assertions.assertThat((Object)value.get("after")).isNotNull();
    }

    public static void assertDelete(SourceRecord record, boolean keyExpected) {
        if (keyExpected) {
            Assertions.assertThat((Object)record.key()).isNotNull();
            Assertions.assertThat((Object)record.keySchema()).isNotNull();
        } else {
            Assertions.assertThat((Object)record.key()).isNull();
            Assertions.assertThat((Object)record.keySchema()).isNull();
        }
        Assertions.assertThat((Object)record.valueSchema()).isNotNull();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNotNull();
        Assertions.assertThat((String)value.getString("op")).isEqualTo(Envelope.Operation.DELETE.code());
        Assertions.assertThat((Object)value.get("before")).isNotNull();
        Assertions.assertThat((Object)value.get("after")).isNull();
    }

    public static void assertTombstone(SourceRecord record) {
        Assertions.assertThat((Object)record.key()).isNotNull();
        Assertions.assertThat((Object)record.keySchema()).isNotNull();
        Assertions.assertThat((Object)record.value()).isNull();
        Assertions.assertThat((Object)record.valueSchema()).isNull();
    }

    public static void hasValidKey(SourceRecord record, String pkField, int pk) {
        Struct key = (Struct)record.key();
        Assertions.assertThat((Object)key.get(pkField)).isEqualTo((Object)pk);
    }

    public static void assertInsert(SourceRecord record) {
        AssertUtils.assertInsert(record, false);
    }

    public static void assertInsert(SourceRecord record, String pkField, int pk) {
        AssertUtils.hasValidKey(record, pkField, pk);
        AssertUtils.assertInsert(record, true);
    }

    public static void assertRead(SourceRecord record, String pkField, int pk) {
        AssertUtils.hasValidKey(record, pkField, pk);
        AssertUtils.assertRead(record);
    }

    public static void assertUpdate(SourceRecord record) {
        AssertUtils.assertUpdate(record, false);
    }

    public static void assertUpdate(SourceRecord record, String pkField, int pk) {
        AssertUtils.hasValidKey(record, pkField, pk);
        AssertUtils.assertUpdate(record, true);
    }

    public static void assertDelete(SourceRecord record) {
        AssertUtils.assertDelete(record, false);
    }

    public static void assertDelete(SourceRecord record, String pkField, int pk) {
        AssertUtils.hasValidKey(record, pkField, pk);
        AssertUtils.assertDelete(record, true);
    }

    public static void assertProducedTypeOfSourceFunction(DebeziumSourceFunction<RowData> debeziumSourceFunction, DataType expectedProducedType) {
        TypeInformation producedType = debeziumSourceFunction.getProducedType();
        Assertions.assertThat((Object)producedType).isExactlyInstanceOf(InternalTypeInfo.class);
        InternalTypeInfo rowDataInternalTypeInfo = (InternalTypeInfo)producedType;
        DataType producedDataType = rowDataInternalTypeInfo.getDataType();
        Assertions.assertThat((Object)producedDataType).hasToString(expectedProducedType.toString());
    }
}

