/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.utils;

import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.ExternalResource;

public class StaticExternalResourceProxy<T extends ExternalResource>
implements BeforeAllCallback,
AfterAllCallback {
    private final Class<?> resourceClazz;
    private final T resource;

    public StaticExternalResourceProxy(T resource) {
        this.resourceClazz = resource.getClass();
        this.resource = resource;
    }

    public T get() {
        return this.resource;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.invoke(this.resourceClazz, this.resource, "before");
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.invoke(this.resourceClazz, this.resource, "after");
    }

    private void invoke(Class<?> clazz, Object object, String methodName) throws Exception {
        Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        method.invoke(object, new Object[0]);
    }
}

